/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.component.DefaultAction;
import org.icefaces.impl.event.AjaxDisabledWriter;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.util.EnvUtils;

public class FormSubmit
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger(FormSubmit.class.getName());
    public static final String DISABLE_CAPTURE_SUBMIT = "DISABLE_CAPTURE_SUBMIT";
    private static final String CAPTURE_SUBMIT_SUFFIX = "_captureSubmit";
    private boolean deltaSubmit;
    private boolean partialStateSaving;

    public FormSubmit() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.deltaSubmit = EnvUtils.isDeltaSubmit(facesContext);
        this.partialStateSaving = EnvUtils.isPartialStateSaving(facesContext);
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        final UIForm form = (UIForm)event.getSource();
        String componentId = form.getId() + CAPTURE_SUBMIT_SUFFIX;
        UIOutputWriter scriptWriter = new UIOutputWriter(){

            public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                if (form.getAttributes().get(FormSubmit.DISABLE_CAPTURE_SUBMIT) != null) {
                    LOGGER.finer("UIForm has DISABLE_CAPTURE_SUBMIT attribute set, so core not rendering submit capturing script");
                    return;
                }
                Object keyMap = form.getAttributes().get(DefaultAction.class.getName());
                String formId = form.getClientId(context);
                writer.startElement("script", (UIComponent)this);
                writer.writeAttribute("type", (Object)"text/javascript", "type");
                writer.writeAttribute("id", (Object)this.getClientId(context), "id");
                writer.write("ice.captureSubmit('" + formId + "'," + Boolean.toString(FormSubmit.this.deltaSubmit) + ");ice.captureKeypress('" + formId + "'," + (keyMap == null ? "null" : keyMap.toString()) + ");");
                writer.endElement("script");
            }
        };
        scriptWriter.setId(componentId);
        scriptWriter.setTransient(true);
        form.setInView(false);
        form.getChildren().add(0, scriptWriter);
        AjaxDisabledWriter disabledWriter = new AjaxDisabledWriter();
        disabledWriter.setTransient(true);
        form.getChildren().add(disabledWriter);
        form.setInView(true);
    }

    public boolean isListenerForSource(Object source) {
        if (!(source instanceof UIForm)) {
            return false;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return false;
        }
        UIForm htmlForm = (UIForm)source;
        if (htmlForm.getAttributes().get(DISABLE_CAPTURE_SUBMIT) != null) {
            LOGGER.finer("UIForm has DISABLE_CAPTURE_SUBMIT attribute set, so core not capturing submit");
            return false;
        }
        String componentId = htmlForm.getId() + CAPTURE_SUBMIT_SUFFIX;
        if (!this.partialStateSaving) {
            for (UIComponent child : htmlForm.getChildren()) {
                String id = child.getId();
                if (null == id || !id.endsWith(CAPTURE_SUBMIT_SUFFIX)) continue;
                return false;
            }
        }
        for (UIComponent comp : htmlForm.getChildren()) {
            if (!componentId.equals(comp.getId())) continue;
            return false;
        }
        return true;
    }
}

