/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import javax.faces.application.Application;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.event.AjaxDisabledList;
import org.icefaces.impl.event.CommandLinkModifier;
import org.icefaces.util.EnvUtils;

public class MainEventListener
implements SystemEventListener {
    private static String RENDER_STARTED = MainEventListener.class.getName() + "-RENDER_STARTED";

    public MainEventListener() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (EnvUtils.isAutoId(facesContext)) {
            facesContext.getApplication().subscribeToEvent(PostAddToViewEvent.class, (SystemEventListener)this);
            facesContext.getApplication().subscribeToEvent(PreRenderViewEvent.class, (SystemEventListener)this);
        }
        Application app = facesContext.getApplication();
        AjaxDisabledList disabledList = new AjaxDisabledList();
        app.subscribeToEvent(PreRenderComponentEvent.class, (SystemEventListener)disabledList);
        if (EnvUtils.isMyFaces()) {
            CommandLinkModifier clMod = new CommandLinkModifier();
            app.subscribeToEvent(PreRenderComponentEvent.class, (SystemEventListener)clMod);
        }
    }

    public void processEvent(SystemEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(facesContext)) {
            return;
        }
        if (event instanceof PreRenderViewEvent) {
            facesContext.getAttributes().put(RENDER_STARTED, RENDER_STARTED);
            return;
        }
        if (null != facesContext.getAttributes().get(RENDER_STARTED)) {
            return;
        }
        UIComponent component = ((PostAddToViewEvent)event).getComponent();
        String id = component.getId();
        if (null == id) {
            return;
        }
        if (id.startsWith("j_id") && this.shouldModifyId(component)) {
            id = "_" + id.substring(4);
            component.setId(id);
            component.getAttributes().put("id", id);
        }
    }

    public boolean isListenerForSource(Object source) {
        if (source instanceof UIViewRoot) {
            return true;
        }
        return this.shouldModifyId(source);
    }

    public boolean shouldModifyId(Object source) {
        if (source.getClass().getName().startsWith("com.icesoft")) {
            return false;
        }
        String name = source.getClass().getName();
        if (name.equals("javax.faces.component.html.HtmlHead")) {
            return false;
        }
        if (source.getClass().getName().equals("javax.faces.component.html.HtmlBody")) {
            return false;
        }
        boolean classCheck = (source instanceof UIOutput || source instanceof HtmlDataTable || source instanceof HtmlPanelGroup || source instanceof UICommand) && !UIOutput.class.equals(source.getClass());
        return classCheck;
    }
}

