/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceOrdering
implements SystemEventListener {
    private static final Logger Log = Logger.getLogger(ResourceOrdering.class.getName());
    public static final String JS = ".js";
    public static final String CSS = ".css";
    private HashMap<String, ResourceEntry> resourceMap = new HashMap();
    private ArrayList<ResourceEntry> nonRootDependencies = new ArrayList();
    private ArrayList<ResourceEntry> masterDependencyList = new ArrayList();

    public ResourceOrdering() {
        try {
            ExternalContext ec;
            URL warResourceDependencyURL;
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("META-INF/resource-dependency.xml");
            ArrayList<URL> urlList = Collections.list(urls);
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc != null && (warResourceDependencyURL = (ec = fc.getExternalContext()).getResource("/META-INF/resource-dependency.xml")) != null) {
                urlList.add(warResourceDependencyURL);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.processResourceDependencies(db, urlList);
            ArrayList<ResourceEntry> roots = new ArrayList<ResourceEntry>(this.resourceMap.values());
            roots.removeAll(this.nonRootDependencies);
            LinkedList<ResourceEntry> queue = new LinkedList<ResourceEntry>();
            queue.addAll(roots);
            while (!queue.isEmpty()) {
                ResourceEntry entry = (ResourceEntry)queue.removeFirst();
                queue.addAll(entry.getDependants());
                if (this.masterDependencyList.contains(entry)) {
                    this.masterDependencyList.remove(entry);
                }
                this.masterDependencyList.add(entry);
            }
            fc.getExternalContext().getApplicationMap().put(ResourceOrdering.class.getName(), this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void traverseOrderedResources(ResourceIterator iterator) {
        for (ResourceEntry next : this.masterDependencyList) {
            iterator.resource(next.name, next.library, next.target);
        }
    }

    private void processResourceDependencies(DocumentBuilder db, List<URL> urls) {
        Log.log(Level.FINE, "resource-dependency.xml URLs: " + urls);
        for (int index = 0; index < urls.size(); ++index) {
            URL url = urls.get(index);
            try {
                InputStream stream = url.openStream();
                Document doc = db.parse(stream);
                doc.normalizeDocument();
                NodeList resourceElements = doc.getDocumentElement().getChildNodes();
                int l = resourceElements.getLength();
                for (int i = 0; i < l; ++i) {
                    Node node = resourceElements.item(i);
                    if (!(node instanceof Element)) continue;
                    Element resourceElement = (Element)node;
                    String name = resourceElement.getAttribute("name");
                    String library = ResourceOrdering.normalizeLibraryName(resourceElement.getAttribute("library"));
                    String target = ResourceOrdering.normalizeTargetName(resourceElement.getAttribute("target"));
                    ResourceEntry sourceResourceEntry = this.lookupOrCreateResource(name, library, target);
                    this.nonRootDependencies.add(sourceResourceEntry);
                    NodeList dependencies = resourceElement.getElementsByTagName("resource");
                    int ll = dependencies.getLength();
                    for (int j = 0; j < ll; ++j) {
                        Element dependOnResourceElement = (Element)dependencies.item(j);
                        String dependencyName = dependOnResourceElement.getAttribute("name");
                        String dependencyLibrary = ResourceOrdering.normalizeLibraryName(dependOnResourceElement.getAttribute("library"));
                        String dependencyTarget = ResourceOrdering.normalizeTargetName(dependOnResourceElement.getAttribute("target"));
                        ResourceEntry targetResourceEntry = this.lookupOrCreateResource(dependencyName, dependencyLibrary, dependencyTarget);
                        targetResourceEntry.addDependant(sourceResourceEntry);
                    }
                }
                continue;
            }
            catch (Exception e) {
                Log.warning("Failed to process resource dependency metadata at " + url);
            }
        }
    }

    private ResourceEntry lookupOrCreateResource(String name, String library, String target) {
        String key = ResourceEntry.key(name, library, target);
        ResourceEntry entry = this.resourceMap.get(key);
        if (entry == null) {
            entry = new ResourceEntry(name, library, target);
            this.resourceMap.put(key, entry);
            return entry;
        }
        return entry;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event.getSource() instanceof UIViewRoot) {
            FacesContext context = FacesContext.getCurrentInstance();
            UIViewRoot root = (UIViewRoot)event.getSource();
            this.orderResources(context, root, "head");
            this.orderResources(context, root, "body");
        }
    }

    private void orderResources(FacesContext context, UIViewRoot root, String target) {
        String facetName = EnvUtils.isMojarra() ? "javax_faces_location_" + target.toUpperCase() : target;
        UIComponent resourceContainer = (UIComponent)root.getFacets().get(facetName);
        resourceContainer.setInView(false);
        ArrayList<UIComponent> orderedJSChildren = new ArrayList<UIComponent>();
        ArrayList<UIComponent> orderedCSSChildren = new ArrayList<UIComponent>();
        ArrayList<UIComponent> orderedUnknownTypeChildren = new ArrayList<UIComponent>();
        for (ResourceEntry resourceEntry : this.masterDependencyList) {
            List children = resourceContainer.getChildren();
            for (UIComponent next : new ArrayList(children)) {
                Map attributes = next.getAttributes();
                String name = (String)attributes.get("name");
                String library = ResourceOrdering.normalizeLibraryName((String)attributes.get("library"));
                if (!resourceEntry.name.equals(name) || !resourceEntry.library.equals(library)) continue;
                root.removeComponentResource(context, next, target);
                if (name.endsWith(JS)) {
                    orderedJSChildren.add(next);
                    continue;
                }
                if (name.endsWith(CSS)) {
                    orderedCSSChildren.add(next);
                    continue;
                }
                orderedUnknownTypeChildren.add(next);
            }
        }
        ArrayList remainingChildren = new ArrayList(resourceContainer.getChildren());
        for (UIComponent next : remainingChildren) {
            root.removeComponentResource(context, next, target);
            String name = (String)next.getAttributes().get("name");
            if (name == null) {
                orderedUnknownTypeChildren.add(next);
                continue;
            }
            if (name.endsWith(JS)) {
                orderedJSChildren.add(next);
                continue;
            }
            if (name.endsWith(CSS)) {
                orderedCSSChildren.add(next);
                continue;
            }
            orderedUnknownTypeChildren.add(next);
        }
        for (UIComponent componentResource : orderedCSSChildren) {
            root.addComponentResource(context, componentResource, target);
        }
        for (UIComponent componentResource : orderedJSChildren) {
            root.addComponentResource(context, componentResource, target);
        }
        for (UIComponent componentResource : orderedUnknownTypeChildren) {
            root.addComponentResource(context, componentResource, target);
        }
        resourceContainer.setInView(true);
    }

    public boolean isListenerForSource(Object source) {
        return EnvUtils.isICEfacesView(FacesContext.getCurrentInstance()) && source instanceof UIViewRoot;
    }

    private static String normalizeLibraryName(String name) {
        return name == null ? "" : name;
    }

    private static String normalizeTargetName(String name) {
        return name == null || "".equals(name) ? "head" : name;
    }

    public static class RegisterListener
    implements SystemEventListener {
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getApplication().subscribeToEvent(PreRenderComponentEvent.class, (SystemEventListener)new ResourceOrdering());
        }

        public boolean isListenerForSource(Object source) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceEntry {
        private String name;
        private String library;
        private String target;
        private List<ResourceEntry> dependants = new ArrayList<ResourceEntry>();

        private ResourceEntry(String name, String library, String target) {
            this.name = name;
            this.library = library;
            this.target = target;
        }

        public void addDependant(ResourceEntry entry) {
            this.dependants.add(entry);
        }

        public List<ResourceEntry> getDependants() {
            return this.dependants;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceEntry that = (ResourceEntry)o;
            if (this.library != null ? !this.library.equals(that.library) : that.library != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(that.target) : that.target != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.library != null ? this.library.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }

        public static String key(String name, String library, String target) {
            return name + library + target;
        }

        public String toString() {
            return "Resource{name: " + this.name + ", library: " + this.library + ", target: " + this.target + "}";
        }
    }

    public static interface ResourceIterator {
        public void resource(String var1, String var2, String var3);
    }
}

