/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.facelets.tag.icefaces.core;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.util.CoreUtils;
import org.icefaces.util.EnvUtils;

public class RefreshHandler
extends TagHandler {
    public RefreshHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        boolean disabled = this.getDisabled(ctx);
        if (!disabled) {
            FacesContext context = FacesContext.getCurrentInstance();
            RefreshSetupOutput refreshSetup = new RefreshSetupOutput(this.getInterval(ctx), this.getDuration(ctx), disabled);
            UIViewRoot viewRoot = context.getViewRoot();
            refreshSetup.setTransient(true);
            refreshSetup.setId(viewRoot.createUniqueId(context, "_setupRefresh"));
            viewRoot.addComponentResource(context, (UIComponent)refreshSetup, "body");
        }
    }

    public long getInterval(FaceletContext ctx) {
        TagAttribute intervalAttribute = this.getAttribute("interval");
        long interval = intervalAttribute == null ? 10000L : Long.valueOf(intervalAttribute.getValue(ctx)) * 1000L;
        return interval;
    }

    public long getDuration(FaceletContext ctx) {
        TagAttribute durationAttribute = this.getAttribute("duration");
        long duration = durationAttribute == null ? -1L : Long.valueOf(durationAttribute.getValue(ctx)) * 60L * 1000L;
        return duration;
    }

    public boolean getDisabled(FaceletContext ctx) {
        TagAttribute disabledAttribute = this.getAttribute("disabled");
        boolean disabled = disabledAttribute == null ? false : Boolean.parseBoolean(disabledAttribute.getValue(ctx));
        disabled = this.getDuration(ctx) == 0L ? true : disabled;
        return disabled;
    }

    private class RefreshSetupOutput
    extends UIOutput {
        private long interval;
        private long duration;
        private boolean disabled;

        public RefreshSetupOutput(long interval, long duration, boolean disabled) {
            this.interval = interval;
            this.duration = duration;
            this.disabled = disabled;
        }

        public void encodeBegin(FacesContext context) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", (UIComponent)this);
            String clientId = this.getClientId(context);
            writer.writeAttribute("id", (Object)clientId, null);
            CoreUtils.enableOnElementUpdateNotify(writer, clientId);
            writer.startElement("script", (UIComponent)this);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeText((Object)"ice.setupRefresh('", null);
            writer.writeText((Object)BridgeSetup.getViewID(context.getExternalContext()), null);
            writer.writeText((Object)"', ", null);
            writer.writeText((Object)this.interval, null);
            writer.writeText((Object)", ", null);
            writer.writeText((Object)this.duration, null);
            writer.writeText((Object)", '", null);
            writer.writeText((Object)clientId, null);
            writer.writeText((Object)"', '", null);
            writer.writeText((Object)EnvUtils.getUpdateNetworkErrorRetryTimeouts(context), null);
            writer.writeText((Object)"');", null);
            writer.endElement("script");
            writer.endElement("span");
        }

        public void encodeEnd(FacesContext context) throws IOException {
        }
    }
}

