/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.icefaces.application.ResourceRegistry;
import org.icefaces.impl.push.DynamicResourceRegistry;
import org.icefaces.impl.push.http.DynamicResource;
import org.icefaces.impl.push.http.DynamicResourceLinker;

public class DynamicResourceDispatcher
extends ResourceHandlerWrapper
implements DynamicResourceRegistry {
    private static Logger log = Logger.getLogger("org.icefaces.resourcedispatcher");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final DynamicResourceLinker.Handler NOOPHandler;
    private ResourceHandler wrapped;

    public DynamicResourceDispatcher(ResourceHandler wrapped) {
        this.wrapped = wrapped;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        externalContext.getApplicationMap().put(DynamicResourceDispatcher.class.getName(), this);
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public URI registerResource(DynamicResource resource) {
        return this.registerResource(resource, NOOPHandler);
    }

    private String encodeCharacter(char c) {
        if (c == '%') {
            return "%25";
        }
        if (c == ' ') {
            return "%20";
        }
        if (c == '!') {
            return "%21";
        }
        if (c == '\"') {
            return "%22";
        }
        if (c == '#') {
            return "%23";
        }
        if (c == '$') {
            return "%24";
        }
        if (c == '&') {
            return "%26";
        }
        if (c == '\'') {
            return "%27";
        }
        if (c == '(') {
            return "%28";
        }
        if (c == ')') {
            return "%29";
        }
        if (c == '*') {
            return "%2A";
        }
        if (c == '+') {
            return "%2B";
        }
        if (c == ',') {
            return "%2C";
        }
        if (c == '-') {
            return "%2D";
        }
        if (c == '.') {
            return "%2E";
        }
        if (c == '/') {
            return "%2F";
        }
        if (c == ':') {
            return "%3A";
        }
        if (c == ';') {
            return "%3B";
        }
        if (c == '<') {
            return "%3C";
        }
        if (c == '=') {
            return "%3D";
        }
        if (c == '>') {
            return "%3E";
        }
        if (c == '?') {
            return "%3F";
        }
        if (c == '@') {
            return "%40";
        }
        if (c == '[') {
            return "%5B";
        }
        if (c == '\\') {
            return "%5C";
        }
        if (c == ']') {
            return "%5D";
        }
        if (c == '^') {
            return "%5E";
        }
        if (c == '_') {
            return "%5F";
        }
        if (c == '`') {
            return "%60";
        }
        if (c == '{') {
            return "%7B";
        }
        if (c == '|') {
            return "%7C";
        }
        if (c == '}') {
            return "%7D";
        }
        if (c == '~') {
            return "%7E";
        }
        return "" + c;
    }

    private String escapeSpecialCharacters(ProxyResource resourceProxy) {
        String originalPath = resourceProxy.getRequestPath();
        String originalFileName = resourceProxy.getResourceName();
        originalFileName = originalFileName != null ? originalFileName : "";
        StringBuffer sb = new StringBuffer(originalFileName.length() * 2);
        for (int i = 0; i < originalFileName.length(); ++i) {
            char c = originalFileName.charAt(i);
            sb.append(this.encodeCharacter(c));
        }
        String escapedFileName = sb.toString();
        int fileNameIndex = originalPath.indexOf(originalFileName);
        int fileNameLength = originalFileName.length();
        return originalPath.substring(0, fileNameIndex) + escapedFileName + originalPath.substring(fileNameIndex + fileNameLength);
    }

    public URI registerResource(DynamicResource resource, DynamicResourceLinker.Handler linkerHandler) {
        try {
            ProxyResource resourceProxy = new ProxyResource(resource);
            return new URI(this.escapeSpecialCharacters(resourceProxy));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create resource.", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create resource.", e);
        }
    }

    public static String encodeContentDispositionFilename(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        String userAgent = DynamicResourceDispatcher.getUserAgent();
        String defaultFileName = "=\"" + fileName + "\"";
        if (userAgent == null || userAgent.trim().length() == 0) {
            return defaultFileName;
        }
        userAgent = userAgent.toLowerCase();
        try {
            if (userAgent.indexOf("msie") > -1) {
                return DynamicResourceDispatcher.encodeForIE(fileName);
            }
            if (userAgent.indexOf("firefox") > -1 || userAgent.indexOf("opera") > -1) {
                return DynamicResourceDispatcher.encodeForFirefox(fileName);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.FINE, "Unknown encoding", e);
        }
        return defaultFileName;
    }

    private static String encodeForIE(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("=\"");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        encodedFileName.append("\"");
        return encodedFileName.toString();
    }

    private static String encodeForFirefox(String fileName) throws UnsupportedEncodingException {
        StringBuffer encodedFileName = new StringBuffer();
        encodedFileName.append("*=UTF-8''");
        encodedFileName.append(URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20"));
        return encodedFileName.toString();
    }

    private static String getUserAgent() {
        Map headerMap = FacesContext.getCurrentInstance().getExternalContext().getRequestHeaderMap();
        return (String)headerMap.get("user-agent");
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        NOOPHandler = new DynamicResourceLinker.Handler(){

            public void linkWith(DynamicResourceLinker linker) {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyResource
    extends Resource {
        private DynamicResource resource;
        private HashMap responseHeaders = new HashMap();
        private Date lastModified = new Date();
        private String requestPath;
        private String fileName;
        private boolean attachment;
        private String contentType;

        public ProxyResource(DynamicResource resource) throws IOException {
            this.resource = resource;
            resource.withOptions(new DynamicResource.Options(){

                public void setMimeType(String mimeType) {
                    ProxyResource.this.contentType = mimeType;
                }

                public void setLastModified(Date date) {
                    ProxyResource.this.responseHeaders.put("Last-Modified", DATE_FORMAT.format(ProxyResource.this.lastModified));
                }

                public void setFileName(String name) {
                    ProxyResource.this.fileName = name;
                    if (ProxyResource.this.attachment) {
                        ProxyResource.this.setAttachmentFileName(ProxyResource.this.fileName);
                    }
                }

                public void setExpiresBy(Date date) {
                    ProxyResource.this.responseHeaders.put("Expires-By", DATE_FORMAT.format(ProxyResource.this.lastModified));
                }

                public void setAsAttachement() {
                    ProxyResource.this.attachment = true;
                    if (ProxyResource.this.fileName != null) {
                        ProxyResource.this.setAttachmentFileName(ProxyResource.this.fileName);
                    }
                }
            });
            this.requestPath = ResourceRegistry.addSessionResource(this);
        }

        public InputStream getInputStream() throws IOException {
            return this.resource.open();
        }

        public Map<String, String> getResponseHeaders() {
            return this.responseHeaders;
        }

        public String getRequestPath() {
            return this.requestPath;
        }

        public URL getURL() {
            return null;
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            return false;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
        }

        public String getLibraryName() {
            return "";
        }

        public void setLibraryName(String libraryName) {
        }

        public String getResourceName() {
            return this.fileName;
        }

        public void setResourceName(String resourceName) {
        }

        public void setAttachmentFileName(String fileName) {
            String name = DynamicResourceDispatcher.encodeContentDispositionFilename(fileName);
            if (name != null) {
                this.responseHeaders.put("Content-Disposition", "attachment; filename" + name);
            }
        }
    }
}

