/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.push;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.icepush.PushContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionViewManager {
    private static final Logger LOGGER = Logger.getLogger(SessionViewManager.class.getName());

    public static void addCurrentSessionToGroup(FacesContext facesContext, String groupName) {
        SessionViewManager.startAddingNewViewsToGroup(facesContext, groupName);
        PushContext pushContext = SessionViewManager.getPushContext(facesContext);
        State state = SessionViewManager.getState(facesContext);
        Iterator viewIDs = state.viewIDSet.iterator();
        while (viewIDs.hasNext()) {
            pushContext.addGroupMember(groupName, (String)viewIDs.next());
        }
    }

    public static void addView(FacesContext context, String id) {
        PushContext pushContext = SessionViewManager.getPushContext(context);
        State state = SessionViewManager.getState(context);
        state.viewIDSet.add(id);
        pushContext.addGroupMember(state.groupName, id);
        Iterator i = state.groups.iterator();
        while (i.hasNext()) {
            pushContext.addGroupMember((String)i.next(), id);
        }
    }

    public static Set<String> getCurrentSessionViewSet(FacesContext facesContext) {
        return Collections.unmodifiableSet(SessionViewManager.getState(facesContext).viewIDSet);
    }

    public static void removeCurrentSessionFromGroup(FacesContext facesContext, String groupName) {
        SessionViewManager.stopAddingNewViewsToGroup(facesContext, groupName);
        PushContext pushContext = SessionViewManager.getPushContext(facesContext);
        State state = SessionViewManager.getState(facesContext);
        Iterator viewIDs = state.viewIDSet.iterator();
        while (viewIDs.hasNext()) {
            pushContext.removeGroupMember(groupName, (String)viewIDs.next());
        }
    }

    public static void removeView(FacesContext context, String id) {
        PushContext pushContext = SessionViewManager.getPushContext(context);
        State state = SessionViewManager.getState(context);
        state.viewIDSet.remove(id);
        pushContext.removeGroupMember(state.groupName, id);
        Iterator i = state.groups.iterator();
        while (i.hasNext()) {
            pushContext.removeGroupMember((String)i.next(), id);
        }
    }

    public static void startAddingNewViewsToGroup(FacesContext context, String groupName) {
        State state = SessionViewManager.getState(context);
        state.groups.add(groupName);
    }

    public static void stopAddingNewViewsToGroup(FacesContext context, String groupName) {
        State state = SessionViewManager.getState(context);
        state.groups.remove(groupName);
    }

    private static PushContext getPushContext(FacesContext facesContext) {
        return (PushContext)facesContext.getExternalContext().getApplicationMap().get(PushContext.class.getName());
    }

    private static State getState(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        State state = (State)sessionMap.get(SessionViewManager.class.getName());
        if (state == null) {
            Object session = context.getExternalContext().getSession(true);
            if (session instanceof HttpSession) {
                state = new State(((HttpSession)session).getId());
            } else if (session instanceof PortletSession) {
                state = new State(((PortletSession)session).getId());
            } else {
                throw new RuntimeException("Unknown session object: " + session);
            }
            sessionMap.put(SessionViewManager.class.getName(), state);
        }
        return state;
    }

    private static class State
    implements Serializable {
        private final CopyOnWriteArraySet<String> viewIDSet = new CopyOnWriteArraySet();
        private String groupName;
        private HashSet groups = new HashSet();

        private State(String groupName) {
            this.groupName = groupName;
        }
    }
}

