/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class Base64 {
    private static final byte[] BASE64_ALPHABET_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] BASE64_FOR_URL_ALPHABET_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte PAD = 61;
    private static final int DECODE_SIZE = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int MASK_8BITS = 255;
    private static final int EOF = -1;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static byte[] encode(byte[] bytes) {
        return Base64.encode(bytes, BASE64_ALPHABET_ARRAY, true);
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.encode(string.getBytes()));
    }

    public static byte[] encodeForURL(byte[] bytes) {
        return Base64.encode(bytes, BASE64_FOR_URL_ALPHABET_ARRAY, false);
    }

    private static byte[] encode(byte[] bytes, byte[] alphabetArray, boolean usePadding) {
        int _group;
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return bytes;
        }
        int _length = bytes.length;
        int _remainder = _length % 3;
        byte[] _bytes = usePadding ? new byte[(_length + 2) / 3 * 4] : new byte[(_length + 2) / 3 * 4 - (_remainder != 0 ? 3 - _remainder : 0)];
        _length -= _remainder;
        int _index = 0;
        int _i = 0;
        while (_i < _length) {
            _group = (bytes[_i++] & 0xFF) << 16 | (bytes[_i++] & 0xFF) << 8 | bytes[_i++] & 0xFF;
            _bytes[_index++] = alphabetArray[_group >>> 18];
            _bytes[_index++] = alphabetArray[_group >>> 12 & 0x3F];
            _bytes[_index++] = alphabetArray[_group >>> 6 & 0x3F];
            _bytes[_index++] = alphabetArray[_group & 0x3F];
        }
        switch (_remainder) {
            case 0: {
                break;
            }
            case 1: {
                _group = (bytes[_i] & 0xFF) << 4;
                _bytes[_index++] = alphabetArray[_group >>> 6];
                if (usePadding) {
                    _bytes[_index++] = alphabetArray[_group & 0x3F];
                    _bytes[_index++] = 61;
                    _bytes[_index] = 61;
                    break;
                }
                _bytes[_index] = alphabetArray[_group & 0x3F];
                break;
            }
            case 2: {
                _group = ((bytes[_i++] & 0xFF) << 8 | bytes[_i] & 0xFF) << 2;
                _bytes[_index++] = alphabetArray[_group >>> 12];
                _bytes[_index++] = alphabetArray[_group >>> 6 & 0x3F];
                if (usePadding) {
                    _bytes[_index++] = alphabetArray[_group & 0x3F];
                    _bytes[_index] = 61;
                    break;
                }
                _bytes[_index] = alphabetArray[_group & 0x3F];
                break;
            }
        }
        return _bytes;
    }

    public static byte[] decode(String pArray) {
        return Base64.decode(Base64.getBytesUtf8(pArray));
    }

    public static byte[] decode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        Base64.decode(pArray, 0, pArray.length, context);
        Base64.decode(pArray, 0, -1, context);
        byte[] result = new byte[context.pos];
        Base64.readResults(result, 0, result.length, context);
        return result;
    }

    private static void decode(byte[] in, int inPos, int inAvail, Context context) {
        if (context.eof) {
            return;
        }
        if (inAvail < 0) {
            context.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte result;
            byte b;
            byte[] buffer = Base64.ensureBufferSize(3, context);
            if ((b = in[inPos++]) == 61) {
                context.eof = true;
                break;
            }
            if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
            context.modulus = (context.modulus + 1) % 4;
            context.ibitWorkArea = (context.ibitWorkArea << 6) + result;
            if (context.modulus != 0) continue;
            buffer[context.pos++] = (byte)(context.ibitWorkArea >> 16 & 0xFF);
            buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
            buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
        }
        if (context.eof && context.modulus != 0) {
            byte[] buffer = Base64.ensureBufferSize(3, context);
            switch (context.modulus) {
                case 1: {
                    break;
                }
                case 2: {
                    context.ibitWorkArea >>= 4;
                    buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    context.ibitWorkArea >>= 2;
                    buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                    buffer[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
        }
    }

    private static byte[] ensureBufferSize(int size, Context context) {
        if (context.buffer == null || context.buffer.length < context.pos + size) {
            return Base64.resizeBuffer(context);
        }
        return context.buffer;
    }

    private static byte[] resizeBuffer(Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[8192];
            context.pos = 0;
            context.readPos = 0;
        } else {
            byte[] b = new byte[context.buffer.length * 2];
            System.arraycopy(context.buffer, 0, b, 0, context.buffer.length);
            context.buffer = b;
        }
        return context.buffer;
    }

    private static int readResults(byte[] b, int bPos, int bAvail, Context context) {
        if (context.buffer != null) {
            int len = Math.min(Base64.available(context), bAvail);
            System.arraycopy(context.buffer, context.readPos, b, bPos, len);
            context.readPos += len;
            if (context.readPos >= context.pos) {
                context.buffer = null;
            }
            return len;
        }
        return context.eof ? -1 : 0;
    }

    private static int available(Context context) {
        return context.buffer != null ? context.pos - context.readPos : 0;
    }

    private static byte[] getBytesUtf8(String string) {
        byte[] bytes;
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = new byte[]{};
        }
        return bytes;
    }

    private static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

