/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    private static Logger log = Logger.getLogger("org.icefaces.util.DOMUtil");
    private static HashSet<String> TAGS_THAT_CAN_CLOSE_SHORT = new HashSet<String>(Arrays.asList("img", "input", "br", "hr", "meta", "base", "link", "frame", "col", "area"));
    private static HashSet<String> TAGS_THAT_ALLOW_NEWLINE = new HashSet<String>(Arrays.asList("img", "input", "td"));
    private static Pattern CDATA_END = Pattern.compile("]]>");
    private static DocumentBuilder DOCUMENT_BUILDER;
    private static boolean isDOMChecking;
    public static String DIFF_SUPPRESS;
    public static String DIFF_INSDEL;
    public static String DIFF_TRUE;
    private static String PAD;
    private static boolean pruneCheckWarned;
    private static String[] ansiCharacters;

    public static Document getNewDocument() {
        Document doc = DOCUMENT_BUILDER.newDocument();
        DOMUtils.applyDocumentSettings(doc);
        return doc;
    }

    private static void applyDocumentSettings(Document doc) {
        block3: {
            if (!isDOMChecking) {
                Method setErrorCheckingMethod = null;
                try {
                    setErrorCheckingMethod = doc.getClass().getMethod("setErrorChecking", Boolean.TYPE);
                    setErrorCheckingMethod.invoke((Object)doc, Boolean.FALSE);
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.log(Level.FINE, "DOM error checking not disabled ", e);
                }
            }
        }
    }

    public static String DocumentTypetoString(String publicID, String systemID, String root) {
        return "<!DOCTYPE " + root + " PUBLIC \"" + publicID + "\" \"" + systemID + "\">";
    }

    public static String nodeToString(Node node) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            DOMUtils.printNode(node, writer);
        }
        finally {
            writer.flush();
            return writer.toString();
        }
    }

    public static String childrenToString(Node node) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            DOMUtils.printChildNodes(node, writer);
        }
        finally {
            writer.flush();
            return writer.toString();
        }
    }

    public static void printChildNodes(Node node, Writer writer) throws IOException {
        NodeList children = node.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            DOMUtils.printNode(children.item(i), writer);
        }
    }

    public static void printNodeCDATA(Node node, Writer writer) throws IOException {
        DOMUtils.printNode(node, writer, 0, true, false, true);
    }

    public static void printNode(Node node, Writer writer) throws IOException {
        DOMUtils.printNode(node, writer, 0, true, false, false);
    }

    private static void printNode(Node node, Writer writer, int depth, boolean allowAddingWhitespace, boolean addTrailingNewline, boolean isInCdata) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    DOMUtils.printNode(nodes.item(i), writer, depth + 1, allowAddingWhitespace, false, isInCdata);
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write("<");
                writer.write(name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" ");
                    writer.write(current.getNodeName());
                    writer.write("=\"");
                    writer.write(DOMUtils.escapeAttribute(current.getNodeValue()));
                    writer.write("\"");
                }
                if (!node.hasChildNodes() && DOMUtils.xmlShortClosingAllowed(node)) {
                    writer.write(" />");
                    break;
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int childrenLength = children.getLength();
                    for (int i = 0; i < childrenLength; ++i) {
                        boolean childAddTrailingNewline = false;
                        if (allowAddingWhitespace && i + 1 < childrenLength) {
                            Node nextChild = children.item(i + 1);
                            childAddTrailingNewline = !DOMUtils.isWhitespaceText(nextChild) && DOMUtils.isNewlineAllowedTag(nextChild);
                        }
                        DOMUtils.printNode(children.item(i), writer, depth + 1, allowAddingWhitespace, childAddTrailingNewline, isInCdata);
                    }
                }
                writer.write("</");
                writer.write(name);
                writer.write(">");
                break;
            }
            case 3: {
                if (!isInCdata) {
                    writer.write(node.getNodeValue());
                    break;
                }
                String value = node.getNodeValue();
                String escaped = CDATA_END.matcher(value).replaceAll("]]>]]&gt;<![CDATA[");
                writer.write(escaped);
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
            }
        }
    }

    private static boolean isWhitespaceText(Node node) {
        if (node.getNodeType() == 3) {
            String val = node.getNodeValue();
            if (val == null) {
                return true;
            }
            for (int i = val.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(val.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isNewlineAllowedTag(Node node) {
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName().toLowerCase();
        return nodeType != 1 || !TAGS_THAT_ALLOW_NEWLINE.contains(nodeName);
    }

    private static boolean xmlShortClosingAllowed(Node node) {
        short nodeType = node.getNodeType();
        String nodeName = node.getNodeName().toLowerCase();
        return nodeType == 1 && TAGS_THAT_CAN_CLOSE_SHORT.contains(nodeName);
    }

    public static Node getChildByNodeName(Node node, String name) {
        NodeList children = node.getChildNodes();
        int l = children.getLength();
        for (int i = 0; i < l; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    public static List<EditOperation> domDiff(DiffConfig config, Document oldDOM, Document newDOM) {
        return DOMUtils.nodeDiff(config, oldDOM.getDocumentElement(), newDOM.getDocumentElement());
    }

    public static List<EditOperation> domDiff(Document oldDOM, Document newDOM) {
        return DOMUtils.domDiff(null, oldDOM, newDOM);
    }

    public static List<EditOperation> nodeDiff(DiffConfig config, Node oldNode, Node newNode) {
        CursorList nodeDiffs = new CursorList();
        try {
            boolean success;
            if (DOMUtils.isDebug(config)) {
                log.log(Level.INFO, "nodeDiff debug " + config);
            }
            if (DOMUtils.isDebugAB(config)) {
                DOMUtils.dumpDebugAB(oldNode, newNode);
            }
            if (!(success = DOMUtils.compareNodes(config, nodeDiffs, oldNode, newNode))) {
                log.severe("Diff propagated to root but no ID set " + newNode);
                if (DOMUtils.isDebugAB(config)) {
                    DOMUtils.dumpDebugAB(oldNode, newNode);
                }
            }
            assert (DOMUtils.checkPrunes(nodeDiffs.asList()));
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Pruning failure", t);
        }
        return nodeDiffs.asList();
    }

    public static List<EditOperation> nodeDiff(Node oldNode, Node newNode) {
        return DOMUtils.nodeDiff(null, oldNode, newNode);
    }

    private static boolean compareNodes(DiffConfig config, CursorList nodeDiffs, Node oldNode, Node newNode) {
        String id;
        int startCursor = nodeDiffs.cursor;
        if (!oldNode.getNodeName().equals(newNode.getNodeName())) {
            DOMUtils.debugNameDifference(config, newNode, oldNode, newNode);
            return false;
        }
        if (!DOMUtils.compareIDs(oldNode, newNode)) {
            DOMUtils.debugIdDifference(config, newNode, oldNode, newNode, "A");
            return false;
        }
        if (DOMUtils.isSuppressed(newNode)) {
            return true;
        }
        if (DOMUtils.isAtt(config)) {
            id = DOMUtils.getNodeId(newNode);
            AttributeOperation op = DOMUtils.detectAttributes(id, oldNode, newNode);
            if (null != op) {
                if (null == id) {
                    DOMUtils.debugAttributesDifference(config, newNode, oldNode, newNode, "A");
                    return false;
                }
                if (op.attributes.containsKey("value")) {
                    nodeDiffs.add(new ReplaceOperation(newNode));
                    DOMUtils.debugAttributeValueDifference(config, newNode, oldNode, newNode, "A replace");
                    return true;
                }
                nodeDiffs.add(op);
                DOMUtils.debugAttributesDifference(config, newNode, oldNode, newNode, "B attribute");
            }
        } else if (!DOMUtils.compareAttributes(oldNode, newNode)) {
            String id2 = DOMUtils.getNodeId(newNode);
            if (null == id2) {
                DOMUtils.debugAttributesDifference(config, newNode, oldNode, newNode, "C");
                return false;
            }
            nodeDiffs.add(new ReplaceOperation(newNode));
            DOMUtils.debugAttributesDifference(config, newNode, oldNode, newNode, "D replace");
            return true;
        }
        if (!DOMUtils.compareStrings(oldNode.getNodeValue(), newNode.getNodeValue())) {
            id = DOMUtils.getNodeId(newNode);
            if (null == id) {
                DOMUtils.debugTextValueDifference(config, newNode, oldNode, newNode, "A");
                return false;
            }
            nodeDiffs.add(new ReplaceOperation(newNode));
            DOMUtils.debugTextValueDifference(config, newNode, oldNode, newNode, "B replace");
            return true;
        }
        if (!DOMUtils.isInsDel(config, newNode)) {
            String id3;
            int numDiffs;
            int newChildLength;
            NodeList oldChildNodes = oldNode.getChildNodes();
            NodeList newChildNodes = newNode.getChildNodes();
            int oldChildLength = oldChildNodes.getLength();
            if (oldChildLength != (newChildLength = newChildNodes.getLength())) {
                String id4 = DOMUtils.getNodeId(newNode);
                if (null == id4) {
                    DOMUtils.debugChildCountDifference(config, newNode, oldNode, newNode, oldChildLength, newChildLength, "A");
                    return false;
                }
                nodeDiffs.add(new ReplaceOperation(newNode));
                DOMUtils.debugChildCountDifference(config, newNode, oldNode, newNode, oldChildLength, newChildLength, "B replace");
                return true;
            }
            for (int i = 0; i < newChildLength; ++i) {
                if (DOMUtils.compareNodes(config, nodeDiffs, oldChildNodes.item(i), newChildNodes.item(i))) continue;
                String id5 = DOMUtils.getNodeId(newNode);
                if (null != id5) {
                    nodeDiffs.cursor = startCursor;
                    nodeDiffs.add(new ReplaceOperation(newNode));
                    DOMUtils.diffDebug(config, "replace: diff from below ", newNode);
                    return true;
                }
                return false;
            }
            if (null != config && (numDiffs = nodeDiffs.cursor - startCursor) > config.maxDiffs && null != (id3 = DOMUtils.getNodeId(newNode))) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("DOM diff coalescing " + (nodeDiffs.cursor - startCursor) + " diffs for " + id3);
                }
                nodeDiffs.cursor = startCursor;
                nodeDiffs.add(new ReplaceOperation(newNode));
                DOMUtils.diffDebug(config, "replace: exceeded maxDiffs ", newNode);
                return true;
            }
            return true;
        }
        if (!DOMUtils.findChildOps(config, nodeDiffs, oldNode, newNode)) {
            id = DOMUtils.getNodeId(newNode);
            if (null != id) {
                nodeDiffs.cursor = startCursor;
                nodeDiffs.add(new ReplaceOperation(newNode));
                DOMUtils.diffDebug(config, "replace: diff below ", newNode);
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean findChildOps(DiffConfig config, CursorList nodeDiffs, Node oldNode, Node newNode) {
        NodeList oldChildNodes = oldNode.getChildNodes();
        NodeList newChildNodes = newNode.getChildNodes();
        int oldChildCount = oldChildNodes.getLength();
        int newChildCount = newChildNodes.getLength();
        if (0 == oldChildCount && 0 == newChildCount) {
            return true;
        }
        if (0 == oldChildCount || 0 == newChildCount) {
            if (null == DOMUtils.getNodeId(newNode)) {
                DOMUtils.debugChildCountDifference(config, newNode, oldNode, newNode, oldChildCount, newChildCount, "C");
                return false;
            }
            nodeDiffs.add(new ReplaceOperation(newNode));
            DOMUtils.debugChildCountDifference(config, newNode, oldNode, newNode, oldChildCount, newChildCount, "D replace: cleared");
            return true;
        }
        List<String> oldList = DOMUtils.getListOfIds(oldNode.getChildNodes());
        List<String> newList = DOMUtils.getListOfIds(newNode.getChildNodes());
        ArrayList<EditOperation> ops = new ArrayList<EditOperation>();
        ArrayList<Node> oldDirectCompare = new ArrayList<Node>();
        ArrayList<Node> newDirectCompare = new ArrayList<Node>();
        boolean keepRunning = true;
        int oldListLen = oldList.size();
        int newListLen = newList.size();
        int oldIndex = 0;
        int newIndex = 0;
        while (keepRunning) {
            String currentNew;
            String currentOld = DOMUtils.paddedGet(oldList, oldIndex);
            if (!currentOld.equals(currentNew = DOMUtils.paddedGet(newList, newIndex))) {
                boolean newInOld = oldList.contains(currentNew);
                boolean oldInNew = newList.contains(currentOld);
                EditOperation operation = null;
                String insertAnchor = null;
                if (newInOld && oldInNew) {
                    keepRunning = false;
                    if (null == DOMUtils.getNodeId(newNode)) {
                        DOMUtils.debugNodeDifference(config, newNode, "Node swapped with other", "A");
                        return false;
                    }
                    nodeDiffs.add(new ReplaceOperation(newNode));
                    DOMUtils.debugNodeDifference(config, newNode, "Node swapped with other", "B replace");
                    ops = null;
                    break;
                }
                if (newInOld && !oldInNew) {
                    operation = new DeleteOperation(currentOld);
                    DOMUtils.debugNodeDifference(config, oldNode, "Node deleted " + currentOld, "A");
                    ++oldIndex;
                }
                if (!newInOld && oldInNew) {
                    if (newIndex <= 0) {
                        if (null == DOMUtils.getNodeId(newNode)) {
                            DOMUtils.debugNodeDifference(config, newNode, "Node inserted before other", "A");
                            return false;
                        }
                        nodeDiffs.add(new ReplaceOperation(newNode));
                        DOMUtils.debugNodeDifference(config, newNode, "Node inserted before other", "B replace");
                        ops = null;
                        break;
                    }
                    insertAnchor = DOMUtils.paddedGet(newList, newIndex - 1);
                    if (insertAnchor.startsWith("?")) {
                        if (null == DOMUtils.getNodeId(newNode)) {
                            DOMUtils.debugNodeDifference(config, newNode, "Invalid state", "A");
                            return false;
                        }
                        nodeDiffs.add(new ReplaceOperation(newNode));
                        DOMUtils.debugNodeDifference(config, newNode, "No insert ID", "B replace");
                        ops = null;
                        break;
                    }
                    operation = new InsertOperation(insertAnchor, newChildNodes.item(newIndex));
                    DOMUtils.debugNodeDifference(config, newNode, "Inserted node", "A");
                    DOMUtils.diffDebug(config, "insert: !new old ", newChildNodes.item(newIndex));
                    ++newIndex;
                }
                if (!newInOld && !oldInNew) {
                    if (PAD == currentNew) {
                        operation = new DeleteOperation(currentOld);
                        DOMUtils.diffDebug(config, "delete: ins/del " + currentOld, null);
                    } else if (PAD == currentOld) {
                        if (newIndex <= 0) {
                            if (null == DOMUtils.getNodeId(newNode)) {
                                DOMUtils.debugNodeDifference(config, newNode, "Child added to previously empty parent", "A");
                                return false;
                            }
                            nodeDiffs.add(new ReplaceOperation(newNode));
                            DOMUtils.debugNodeDifference(config, newNode, "Child added to previously empty parent", "B replace");
                            ops = null;
                            break;
                        }
                        insertAnchor = DOMUtils.paddedGet(newList, newIndex - 1);
                        if (insertAnchor.startsWith("?")) {
                            if (null == DOMUtils.getNodeId(newNode)) {
                                DOMUtils.debugNodeDifference(config, newNode, "Invalid state", "C");
                                return false;
                            }
                            nodeDiffs.add(new ReplaceOperation(newNode));
                            DOMUtils.debugNodeDifference(config, newNode, "No insert ID", "D replace");
                            ops = null;
                            break;
                        }
                        operation = new InsertOperation(insertAnchor, newChildNodes.item(newIndex));
                        DOMUtils.debugNodeDifference(config, newNode, "Inserted node", "B");
                        DOMUtils.diffDebug(config, "insert2 ", newChildNodes.item(newIndex));
                    } else {
                        if (null == DOMUtils.getNodeId(newNode)) {
                            DOMUtils.debugIdDifference(config, newNode, oldNode, newNode, "B");
                            return false;
                        }
                        nodeDiffs.add(new ReplaceOperation(newNode));
                        DOMUtils.debugIdDifference(config, newNode, oldNode, newNode, "C replace");
                        ops = null;
                        break;
                    }
                    ++oldIndex;
                    ++newIndex;
                }
                ops.add(operation);
            } else {
                oldDirectCompare.add(oldChildNodes.item(oldIndex));
                newDirectCompare.add(newChildNodes.item(newIndex));
                ++oldIndex;
                ++newIndex;
            }
            if (oldIndex < oldListLen || newIndex < newListLen) continue;
            keepRunning = false;
        }
        if (null != ops) {
            nodeDiffs.addAll(ops);
            int newChildLength = newDirectCompare.size();
            boolean handledBelow = true;
            for (int i = 0; i < newChildLength; ++i) {
                if (DOMUtils.compareNodes(config, nodeDiffs, (Node)oldDirectCompare.get(i), (Node)newDirectCompare.get(i))) continue;
                handledBelow = false;
            }
            return handledBelow;
        }
        return true;
    }

    private static String paddedGet(List<String> theList, int theIndex) {
        if (theIndex >= theList.size()) {
            return PAD;
        }
        return theList.get(theIndex);
    }

    private static boolean paddedContains(List<String> theList, String theValue) {
        if (PAD == theValue) {
            return true;
        }
        return theList.contains(theValue);
    }

    private static List<Node> getListOfNodes(NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Node> listOfNode = new ArrayList<Node>(length);
        for (int i = 0; i < length; ++i) {
            listOfNode.add(nodeList.item(i));
        }
        return listOfNode;
    }

    private static List<String> getListOfIds(NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<String> listOfIds = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String tempId;
            Node node = nodeList.item(i);
            String id = "?" + i;
            if (node instanceof Element && null != (tempId = ((Element)node).getAttribute("id")) && !"".equals(tempId)) {
                id = tempId;
            }
            listOfIds.add(id);
        }
        return listOfIds;
    }

    private static boolean compareStrings(String oldString, String newString) {
        if (null == oldString && null == newString) {
            return true;
        }
        try {
            return oldString.equals(newString);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static boolean compareIDs(Node oldNode, Node newNode) {
        if (!(oldNode instanceof Element) && !(newNode instanceof Element)) {
            return true;
        }
        try {
            return ((Element)oldNode).getAttribute("id").equals(((Element)newNode).getAttribute("id"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean compareAttributes(Node oldNode, Node newNode) {
        int newLength;
        boolean oldHasAttributes = oldNode.hasAttributes();
        boolean newHasAttributes = newNode.hasAttributes();
        if (!oldHasAttributes && !newHasAttributes) {
            return true;
        }
        if (oldHasAttributes != newHasAttributes) {
            return false;
        }
        NamedNodeMap oldMap = oldNode.getAttributes();
        NamedNodeMap newMap = newNode.getAttributes();
        int oldLength = oldMap.getLength();
        if (oldLength != (newLength = newMap.getLength())) {
            return false;
        }
        Node newAttribute = null;
        Node oldAttribute = null;
        for (int i = 0; i < newLength; ++i) {
            newAttribute = newMap.item(i);
            oldAttribute = oldMap.getNamedItem(newAttribute.getNodeName());
            if (null == oldAttribute) {
                return false;
            }
            if (String.valueOf(oldAttribute.getNodeValue()).equals(String.valueOf(newAttribute.getNodeValue()))) continue;
            return false;
        }
        return true;
    }

    public static AttributeOperation detectAttributes(String id, Node oldNode, Node newNode) {
        int i;
        boolean oldHasAttributes = oldNode.hasAttributes();
        boolean newHasAttributes = newNode.hasAttributes();
        if (!oldHasAttributes && !newHasAttributes) {
            return null;
        }
        HashMap<String, String> output = new HashMap<String, String>();
        NamedNodeMap oldMap = oldNode.getAttributes();
        NamedNodeMap newMap = newNode.getAttributes();
        int oldLength = oldMap.getLength();
        int newLength = newMap.getLength();
        Node newAttribute = null;
        Node oldAttribute = null;
        for (i = 0; i < newLength; ++i) {
            newAttribute = newMap.item(i);
            String newName = newAttribute.getNodeName();
            String newValue = newAttribute.getNodeValue();
            oldAttribute = oldMap.getNamedItem(newName);
            if (null == oldAttribute) {
                output.put(newName, newValue);
                continue;
            }
            if (newValue.equals(oldAttribute.getNodeValue())) continue;
            output.put(newName, newValue);
        }
        for (i = 0; i < oldLength; ++i) {
            oldAttribute = oldMap.item(i);
            String oldName = oldAttribute.getNodeName();
            newAttribute = newMap.getNamedItem(oldName);
            if (null != newAttribute) continue;
            output.put(oldName, "");
        }
        if (output.size() > 0) {
            return new AttributeOperation(id, newNode, output);
        }
        return null;
    }

    public static boolean isDOMDiffFeature(String feature, Node newNode) {
        String featureValue;
        if (!newNode.hasAttributes()) {
            return false;
        }
        NamedNodeMap newMap = newNode.getAttributes();
        Node featureMarker = newMap.getNamedItem(feature);
        if (null != featureMarker && DIFF_TRUE.equals(featureValue = featureMarker.getNodeValue())) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("DOM diff " + feature + " on " + newNode);
            }
            return true;
        }
        return false;
    }

    public static boolean isSuppressed(Node newNode) {
        return DOMUtils.isDOMDiffFeature(DIFF_SUPPRESS, newNode);
    }

    public static boolean isInsDel(DiffConfig config, Node newNode) {
        if (null != config && config.isInsDel) {
            return true;
        }
        return DOMUtils.isDOMDiffFeature(DIFF_INSDEL, newNode);
    }

    public static boolean isAtt(DiffConfig config) {
        return null != config && config.isAtt;
    }

    static void diffDebug(DiffConfig config, String message, Node node) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String nodePath = "";
        for (Node parent = node; null != parent; parent = parent.getParentNode()) {
            nodePath = DOMUtils.toDebugString(parent) + " " + nodePath;
        }
        log.info(message + nodePath);
    }

    static boolean isDebug(DiffConfig config) {
        return null != config && config.isDebug;
    }

    static boolean isDebugAB(DiffConfig config) {
        return null != config && config.isDebugAB;
    }

    static void dumpDebugAB(Node oldNode, Node newNode) {
        String oldDebug = "null document";
        String newDebug = "null document";
        if (null != oldNode) {
            oldDebug = DOMUtils.toDebugStringDeep(oldNode);
        }
        if (null != newNode) {
            newDebug = DOMUtils.toDebugStringDeep(newNode);
        }
        log.log(Level.INFO, "nodeDiff--------------debugA\n");
        log.log(Level.INFO, "nodeDiff oldNode \n" + oldDebug);
        log.log(Level.INFO, "nodeDiff--------------debugB\n");
        log.log(Level.INFO, "nodeDiff newNode \n" + newDebug);
        log.log(Level.INFO, "nodeDiff--------------------\n");
    }

    public static String getNodeId(Node node) {
        String id;
        if (node instanceof Element && null != (id = ((Element)node).getAttribute("id")) && !"".equals(id)) {
            return id;
        }
        return null;
    }

    private static boolean checkPrunes(List<EditOperation> nodeDiffs) {
        if (!pruneCheckWarned) {
            log.severe("nodeDiff assertion checking active, disable to improve performance");
            pruneCheckWarned = true;
        }
        ArrayList<Node> justNodes = new ArrayList<Node>();
        for (EditOperation op : nodeDiffs) {
            if (!(op instanceof ReplaceOperation)) continue;
            Node startNode = op.element;
            Element ascendNode = DOMUtils.ascendToNodeWithID(op.element);
            if (!startNode.equals(ascendNode)) {
                log.warning("ID missing " + startNode + " " + ascendNode);
                return false;
            }
            op.element = ascendNode;
            justNodes.add(op.element);
        }
        Node[] prunedDiff = null;
        try {
            prunedDiff = DOMUtils.pruneAncestors(justNodes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == prunedDiff && 0 == nodeDiffs.size()) {
            return true;
        }
        if (nodeDiffs.size() == prunedDiff.length) {
            return true;
        }
        log.warning("pruning occured " + nodeDiffs.size() + " " + prunedDiff.length);
        return false;
    }

    public static Element ascendToNodeWithID(Node start) {
        for (Node node = start; null != node; node = node.getParentNode()) {
            String id;
            if (!(node instanceof Element) || null == (id = ((Element)node).getAttribute("id")) || "".equals(id)) continue;
            return (Element)node;
        }
        return start.getOwnerDocument().getDocumentElement();
    }

    public static boolean escapeIsRequired(UIComponent uiComponent) {
        Object escapeAttribute = uiComponent.getAttributes().get("escape");
        if (escapeAttribute != null) {
            if (escapeAttribute instanceof String) {
                return Boolean.valueOf((String)escapeAttribute);
            }
            if (escapeAttribute instanceof Boolean) {
                return (Boolean)escapeAttribute;
            }
        }
        return true;
    }

    public static String escapeAttribute(String text) {
        if (null == text) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch <= '\u001f') {
                if (ch != '\t' && ch != '\n' && ch != '\r') continue;
                buffer.append(ch);
                continue;
            }
            if (ch == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buffer.append("&quot;");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String escapeAnsi(String text) {
        if (null == text) {
            return "";
        }
        char[] chars = text.toCharArray();
        StringBuffer buffer = new StringBuffer(chars.length);
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch <= '\u001f') {
                if (ch != '\t' && ch != '\n' && ch != '\r') continue;
                buffer.append(ch);
                continue;
            }
            if (ch == '\u007f') continue;
            if (ch == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (ch == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (ch == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                buffer.append("&#39;");
                continue;
            }
            if (ch == '\"') {
                buffer.append("&#34;");
                continue;
            }
            if (ch >= '\u00a0' && ch <= '\u00ff') {
                buffer.append("&#").append(Integer.toString(ch)).append(";");
                continue;
            }
            if (ch == '\u20ac') {
                buffer.append("&#8364;");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static String escapeAnsi(char character) {
        int indexOfEscapedCharacter = character - 160;
        return ansiCharacters[indexOfEscapedCharacter];
    }

    private static Node[] pruneAncestors(List nodeList) {
        Node[] changed = nodeList.toArray(new Node[0]);
        HashMap<Integer, HashSet<Element>> depthMaps = new HashMap<Integer, HashSet<Element>>();
        for (int i = 0; i < changed.length; ++i) {
            Element changeRoot = DOMUtils.ascendToNodeWithID(changed[i]);
            changed[i] = changeRoot;
            Integer depth = new Integer(DOMUtils.getDepth(changeRoot));
            HashSet<Element> peers = (HashSet<Element>)depthMaps.get(depth);
            if (null == peers) {
                peers = new HashSet<Element>();
                depthMaps.put(depth, peers);
            }
            peers.add(changeRoot);
        }
        for (Integer baseDepth : depthMaps.keySet()) {
            for (Integer checkDepth : depthMaps.keySet()) {
                if (baseDepth >= checkDepth) continue;
                DOMUtils.pruneAncestors(baseDepth, (HashSet)depthMaps.get(baseDepth), checkDepth, (HashSet)depthMaps.get(checkDepth));
            }
        }
        HashSet topElements = new HashSet();
        Iterator allDepthMaps = depthMaps.values().iterator();
        while (allDepthMaps.hasNext()) {
            topElements.addAll((HashSet)allDepthMaps.next());
        }
        Element[] elements = null;
        if (!topElements.isEmpty()) {
            boolean reload = false;
            int j = 0;
            elements = new Element[topElements.size()];
            HashSet<Element> dupCheck = new HashSet<Element>();
            for (int i = 0; i < changed.length; ++i) {
                Element element = (Element)changed[i];
                String tag = element.getTagName();
                boolean bl = reload = reload || "html".equalsIgnoreCase(tag) || "head".equalsIgnoreCase(tag);
                if (!topElements.contains(element) || dupCheck.contains(element)) continue;
                dupCheck.add(element);
                elements[j++] = element;
            }
        }
        return elements;
    }

    private static void pruneAncestors(Integer parentDepth, Collection parents, Integer childDepth, Collection children) {
        for (Node parent : parents) {
            Iterator childList = children.iterator();
            while (childList.hasNext()) {
                Node child = (Node)childList.next();
                if (!DOMUtils.isAncestor(parentDepth, parent, childDepth, child)) continue;
                childList.remove();
            }
        }
    }

    private static int getDepth(Node node) {
        int depth = 0;
        Node parent = node;
        while ((parent = parent.getParentNode()) != null) {
            ++depth;
        }
        return depth;
    }

    private static boolean isAncestor(Integer parentDepth, Node parent, Integer childDepth, Node child) {
        if (!parent.hasChildNodes()) {
            return false;
        }
        Node testParent = child;
        int stopDepth = parentDepth;
        for (int testDepth = childDepth.intValue(); (testParent = testParent.getParentNode()) != null && testDepth > stopDepth; --testDepth) {
            if (!testParent.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static String toDebugStringDeep(Node node) {
        return DOMUtils.toDebugStringDeep(node, "");
    }

    static String toDebugStringDeep(Node node, String indent) {
        String result = DOMUtils.toDebugString(node) + "\n";
        indent = indent + "  ";
        NodeList nodes = node.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                result = result + indent + DOMUtils.toDebugStringDeep(nodes.item(i), indent);
            }
        }
        return result;
    }

    public static String toDebugString(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 2: {
                Attr attr = (Attr)node;
                return "attribute[name: " + attr.getName() + "; value: " + attr.getValue() + "]";
            }
            case 1: {
                Element element = (Element)node;
                StringBuffer buffer = new StringBuffer();
                buffer.append("element[tag: ");
                buffer.append(element.getTagName());
                buffer.append("; attributes: ");
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    buffer.append(attr.getName());
                    buffer.append("=");
                    buffer.append(attr.getValue());
                    buffer.append(' ');
                }
                buffer.append(']');
                return buffer.toString();
            }
            case 4: {
                CDATASection cdataSection = (CDATASection)node;
                return "cdata[" + cdataSection.getData() + "]";
            }
            case 3: {
                Text text = (Text)node;
                return "text[" + text.getData() + "]";
            }
            case 8: {
                Comment comment = (Comment)node;
                return "comment[" + comment.getData() + "]";
            }
            case 6: {
                Entity entity = (Entity)node;
                return "entity[public: " + entity.getPublicId() + "; system: " + entity.getSystemId() + "]";
            }
        }
        return node.getNodeName();
    }

    public static void debugIdDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode, String variant) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Id changed from '" + DOMUtils.getNodeId(oldNode) + "' to '" + DOMUtils.getNodeId(newNode) + "'. Examine attributes:\nOld: " + DOMUtils.describeAttributes(oldNode) + "New: " + DOMUtils.describeAttributes(newNode);
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    public static void debugNameDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Name changed from '" + oldNode.getNodeName() + "' to '" + newNode.getNodeName() + "'. Examine attributes:\nOld: " + DOMUtils.describeAttributes(oldNode) + "New: " + DOMUtils.describeAttributes(newNode);
        log.info(DOMUtils.getDifference(differenceOrigin, null, differenceReason));
    }

    public static void debugAttributesDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode, String variant) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Attributes changed\nOld: " + DOMUtils.describeAttributes(oldNode) + "New: " + DOMUtils.describeAttributes(newNode);
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    public static void debugAttributeValueDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode, String variant) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Attribute 'value' changed\nOld: " + DOMUtils.describeAttributes(oldNode) + "New: " + DOMUtils.describeAttributes(newNode);
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    public static void debugTextValueDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode, String variant) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Text value changed from '" + oldNode.getNodeValue() + "' to '" + newNode.getNodeValue() + "'";
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    public static void debugChildCountDifference(DiffConfig config, Node differenceOrigin, Node oldNode, Node newNode, int oldChildLength, int newChildLength, String variant) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        String differenceReason = "Number of children changed from " + oldChildLength + " to " + newChildLength + "\nOld: " + DOMUtils.describeChildren(oldNode) + "New: " + DOMUtils.describeChildren(newNode);
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    public static void debugNodeDifference(DiffConfig config, Node differenceOrigin, String variant, String differenceReason) {
        if (!DOMUtils.isDebug(config)) {
            return;
        }
        log.info(DOMUtils.getDifference(differenceOrigin, variant, differenceReason));
    }

    private static String getDifference(Node differenceOrigin, String variant, String differenceReason) {
        if (differenceOrigin == null) {
            return null;
        }
        int differenceReasonLength = differenceReason == null ? 0 : differenceReason.length();
        StringBuilder sb = new StringBuilder(256 + differenceReasonLength);
        Node n = differenceOrigin;
        while (true) {
            DOMUtils.describeNodePrepended(n, sb);
            Node p = n.getParentNode();
            if (p == null) break;
            DOMUtils.describeNodeIndexInParentPrepended(p, n, sb);
            n = p;
        }
        if (differenceReason != null) {
            sb.append(" :: ");
            if (variant != null) {
                sb.append("(").append(variant).append(") ");
            }
            sb.append(differenceReason);
        }
        return sb.toString();
    }

    private static void describeNodePrepended(Node n, StringBuilder sb) {
        sb.insert(0, ">");
        String id = DOMUtils.getNodeId(n);
        if (id != null) {
            sb.insert(0, "\"");
            sb.insert(0, id);
            sb.insert(0, " id=\"");
        }
        sb.insert(0, n.getNodeName());
        sb.insert(0, "<");
    }

    private static void describeNodeIndexInParentPrepended(Node p, Node n, StringBuilder sb) {
        NodeList nl = p.getChildNodes();
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            Node c = nl.item(i);
            if (c != n) continue;
            sb.insert(0, "]");
            sb.insert(0, i);
            sb.insert(0, "[");
            return;
        }
    }

    private static String describeChildren(Node n) {
        StringBuilder sb = new StringBuilder(256);
        NodeList nl = n.getChildNodes();
        sb.append("Children: ").append(nl.getLength()).append('\n');
        block6: for (int i = 0; i < nl.getLength(); ++i) {
            sb.append("  [").append(i).append("] ");
            Node c = nl.item(i);
            short type = c.getNodeType();
            switch (type) {
                case 4: {
                    CDATASection cdataSection = (CDATASection)c;
                    sb.append("cdata[").append(cdataSection.getData()).append("]\n");
                    continue block6;
                }
                case 3: {
                    Text text = (Text)c;
                    String str = text.getData();
                    sb.append("text");
                    if (str == null || str.length() == 0) {
                        sb.append(":EMPTY\n");
                        continue block6;
                    }
                    if (str.trim().length() == 0) {
                        sb.append(":WHITESPACE\n");
                        continue block6;
                    }
                    sb.append("[").append(str).append("]\n");
                    continue block6;
                }
                case 8: {
                    Comment comment = (Comment)c;
                    sb.append("comment[").append(comment.getData()).append("]\n");
                    continue block6;
                }
                case 6: {
                    Entity entity = (Entity)c;
                    sb.append("entity[public: ").append(entity.getPublicId()).append("; system: ").append(entity.getSystemId()).append("]\n");
                    continue block6;
                }
                default: {
                    sb.append("<").append(c.getNodeName());
                    String id = DOMUtils.getNodeId(c);
                    if (id != null) {
                        sb.append(" id=\"").append(id).append("\"");
                    }
                    sb.append(">\n");
                    if (id != null) continue block6;
                    DOMUtils.describeAttributes(c, sb, true);
                }
            }
        }
        return sb.toString();
    }

    private static String describeAttributes(Node n) {
        StringBuilder sb = new StringBuilder(256);
        DOMUtils.describeAttributes(n, sb, false);
        return sb.toString();
    }

    private static void describeAttributes(Node n, StringBuilder sb, boolean doubleIndent) {
        int numAttribs;
        NamedNodeMap nnm = n.getAttributes();
        int n2 = numAttribs = nnm == null ? 0 : nnm.getLength();
        if (doubleIndent) {
            sb.append("  ");
        }
        sb.append("Attributes: ").append(numAttribs).append('\n');
        for (int i = 0; i < numAttribs; ++i) {
            Node c = nnm.item(i);
            if (doubleIndent) {
                sb.append("  ");
            }
            sb.append("  [").append(i).append("] ");
            sb.append(c.getNodeName());
            sb.append("=\"").append(c.getNodeValue()).append("\"\n");
        }
    }

    static {
        isDOMChecking = true;
        DIFF_SUPPRESS = "data-ice-diffsuppress";
        DIFF_INSDEL = "data-ice-insdel";
        DIFF_TRUE = "true";
        try {
            DOCUMENT_BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.log(Level.SEVERE, "unable to acquire a DocumentBuilder", e);
        }
        PAD = "not_an_id_of_any_element";
        pruneCheckWarned = false;
        ansiCharacters = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }

    public static class DiffConfig {
        public int maxDiffs = Integer.MAX_VALUE;
        public boolean isInsDel = false;
        public boolean isDebug = false;
        public boolean isDebugAB = false;
        public boolean isAtt = false;
        private static String MAXDIFFS = "maxDiffs";
        private static String INSDEL = "insDel";
        private static String DEBUG = "debug";
        private static String DEBUGAB = "debugAB";
        private static String ATT = "att";
        private static Pattern SPACE_PATTERN = Pattern.compile(" ");

        public DiffConfig(String config) {
            try {
                String attParam;
                String debugABParam;
                String debugParam;
                String insDelParam;
                String[] paramPairs;
                HashMap<String, String> params = new HashMap<String, String>();
                for (String pair : paramPairs = SPACE_PATTERN.split(config)) {
                    int center = pair.indexOf("=");
                    if (-1 != center) {
                        String key = pair.substring(0, center);
                        String value = pair.substring(center + 1);
                        params.put(key, value);
                        continue;
                    }
                    params.put(pair, "true");
                }
                String maxDiffsParam = (String)params.get(MAXDIFFS);
                if (null != maxDiffsParam) {
                    this.maxDiffs = Integer.parseInt(maxDiffsParam);
                }
                if (null != (insDelParam = (String)params.get(INSDEL))) {
                    this.isInsDel = true;
                }
                if (null != (debugParam = (String)params.get(DEBUG))) {
                    this.isDebug = true;
                }
                if (null != (debugABParam = (String)params.get(DEBUGAB))) {
                    this.isDebugAB = true;
                }
                if (null != (attParam = (String)params.get(ATT))) {
                    this.isAtt = true;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Malformed DiffConfig " + config, e);
            }
        }

        public String toString() {
            String values = MAXDIFFS + ": " + String.valueOf(this.maxDiffs) + " " + DEBUG + ": " + String.valueOf(this.isDebug) + " " + DEBUGAB + ": " + String.valueOf(this.isDebugAB) + " " + ATT + ": " + String.valueOf(this.isAtt) + " " + INSDEL + ": " + String.valueOf(this.isInsDel);
            return values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CursorList {
        public int cursor = 0;
        public List<EditOperation> list = new ArrayList<EditOperation>();

        boolean add(EditOperation op) {
            assert (null != DOMUtils.getNodeId(op.element));
            if (this.list.size() == this.cursor) {
                ++this.cursor;
                return this.list.add(op);
            }
            this.list.set(this.cursor++, op);
            return true;
        }

        boolean addAll(List<EditOperation> ops) {
            if (this.list.size() == this.cursor) {
                this.cursor += ops.size();
                return this.list.addAll(ops);
            }
            for (EditOperation op : ops) {
                this.add(op);
            }
            return true;
        }

        public List asList() {
            return this.list.subList(0, this.cursor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeOperation
    extends EditOperation {
        public AttributeOperation(String id, Node element, Map<String, String> attributes) {
            this.id = id;
            this.element = element;
            this.attributes = attributes;
        }
    }

    public static class ReplaceOperation
    extends EditOperation {
        public ReplaceOperation(String id, Node element) {
            this.id = id;
            this.element = element;
        }

        public ReplaceOperation(Node element) {
            this(null, element);
        }
    }

    public static class DeleteOperation
    extends EditOperation {
        public DeleteOperation(String id) {
            this.id = id;
            this.element = null;
        }
    }

    public static class InsertOperation
    extends EditOperation {
        public InsertOperation(String id, Node element) {
            this.id = id;
            this.element = element;
        }
    }

    public static class EditOperation {
        public String id = null;
        public Node element = null;
        public Map<String, String> attributes = null;

        public String toString() {
            return this.getClass().getName() + ":" + this.id + ":" + this.element;
        }
    }
}

