/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.icefaces.resources.BrowserType;

public class UserAgentInfo
implements Serializable {
    private String userAgentString;
    public static final String MAC = "macintosh";
    public static final String WINDOWS = "windows";
    public static final String MSIE = "msie";
    public static final String MSIE6 = "msie 6.0";
    public static final String MSIE7 = "msie 7.0";
    public static final String MSIE8 = "msie 8.0";
    public static final String MSIE9 = "msie 9.0";
    public static final String CHROME = "chrome";
    public static final String CHROMEFRAME = "chromeframe";
    public static final String FIREFOX = "firefox";
    public static final String SAFARI = "safari";
    public static final String ANDROID = "android";
    public static final String MOBILE = "mobile";
    public static final String BLACKBERRY = "blackberry";
    public static final String BLACKBERRY_CURVE = "blackberry89";
    public static final String BLACKBERRY_TORCH = "blackberry 98";
    public static final String IPHONE = "iphone";
    public static final String IPAD = "ipad";
    public static final String IPOD = "ipod";
    public static final String IOS5 = " os 5_";
    public static final String IOS6 = " os 6_";
    public static final String TABLET = "tablet";
    public static final String TABLET_GALAXY = "gt-p1000";
    public static final String TABLET_TRANSORMER_PRIME = "transformer prime";
    public static final String TABLET_IDEATAB = "ideatab";
    public static final String TABLET_KINDLE_FIRE = "kindle fire";
    public static final String PHONE_DROID2 = "droid2";
    public static final String MOBILE_SAFARI = "mobile safari";
    public static final String PHONE_HTC_SENSATION = "sensation_4g";
    public static final String ANDROID_CONTAINER = "apache-httpclient";
    public static final Pattern IE_VERSION_PATTERN = Pattern.compile("msie ([0-9]*).0;");

    public UserAgentInfo(String userAgent) {
        if (userAgent != null) {
            this.userAgentString = userAgent.toLowerCase();
        }
    }

    public boolean isIpod() {
        return this.userAgentString.contains(IPOD);
    }

    public boolean isIphone() {
        return this.userAgentString.contains(IPHONE) && !this.isIpod() && !this.isIpad();
    }

    public boolean isIOS() {
        return this.isIphone() || this.isIpod() || this.isIpad();
    }

    public boolean isIOS5() {
        return this.userAgentString.contains(IOS5);
    }

    public boolean isIOS6() {
        return this.userAgentString.contains(IOS6);
    }

    public boolean isIpad() {
        return this.userAgentString.contains(IPAD);
    }

    public boolean isAndroidOS() {
        return this.userAgentString.contains(ANDROID) || this.userAgentString.contains(ANDROID_CONTAINER);
    }

    public boolean isBlackberryOS() {
        return this.userAgentString.contains(BLACKBERRY);
    }

    public boolean isMacOS() {
        return this.userAgentString.contains(MAC);
    }

    public boolean isWindowsOS() {
        return this.userAgentString.contains(WINDOWS);
    }

    public boolean isDesktopBrowser() {
        if (null != this.userAgentString && this.userAgentString.contains(ANDROID_CONTAINER)) {
            return false;
        }
        return !this.isMobileBrowser() && !this.isTabletBrowser();
    }

    public boolean isMobileBrowser() {
        return (this.userAgentString.matches("(?i).*(android.+mobile|droid2|avantgo|bada\\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|lge |maemo|meego.+mobile|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\\/|plucker|pocket|psp|sensation_4g|series(4|6)0|symbian|treo|up\\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino).*") || this.userAgentString.substring(0, 4).matches("(?i)1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\\-(n|u)|c55\\/|capi|ccwa|cdm\\-|cell|chtm|cldc|cmd\\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\\-s|devi|dica|dmob|do(c|p)o|ds(12|\\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\\-|_)|g1 u|g560|gene|gf\\-5|g\\-mo|go(\\.w|od)|gr(ad|un)|haie|hcit|hd\\-(m|p|t)|hei\\-|hi(pt|ta)|hp( i|ip)|hs\\-c|ht(c(\\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\\-(20|go|ma)|i230|iac( |\\-|\\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\\/)|klon|kpt |kwc\\-|kyo(c|k)|le(no|xi)|lg( g|\\/(k|l|u)|50|54|\\-[a-w])|libw|lynx|m1\\-w|m3ga|m50\\/|ma(te|ui|xo)|mc(01|21|ca)|m\\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\\-2|po(ck|rt|se)|prox|psio|pt\\-g|qa\\-a|qc(07|12|21|32|60|\\-[2-7]|i\\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\\-|oo|p\\-)|sdk\\/|se(c(\\-|0|1)|47|mc|nd|ri)|sgh\\-|shar|sie(\\-|m)|sk\\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\\-|v\\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\\-|tdg\\-|tel(i|m)|tim\\-|t\\-mo|to(pl|sh)|ts(70|m\\-|m3|m5)|tx\\-9|up(\\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\\-|your|zeto|zte\\-")) && !this.userAgentString.contains(TABLET_GALAXY) && !this.userAgentString.contains(TABLET_TRANSORMER_PRIME) && !this.userAgentString.contains(TABLET_IDEATAB) && !this.userAgentString.contains(TABLET_KINDLE_FIRE);
    }

    public boolean isTabletBrowser() {
        return this.userAgentString.matches("(?i).*(android|ipad|playbook|silk|pocket|psp|gt-p1000|transformer prime).*") && !this.userAgentString.contains(MOBILE_SAFARI) && !this.userAgentString.contains(PHONE_DROID2) && !this.userAgentString.contains(PHONE_HTC_SENSATION) || this.userAgentString.contains(TABLET_IDEATAB) || this.userAgentString.contains(TABLET_KINDLE_FIRE);
    }

    public boolean isIE() {
        return this.userAgentString.contains(MSIE);
    }

    public boolean isIE8orLess() {
        return this.userAgentString.contains(MSIE6) || this.userAgentString.contains(MSIE7) || this.userAgentString.contains(MSIE8);
    }

    public boolean isIE7() {
        return this.userAgentString.contains(MSIE7);
    }

    public boolean isIE8() {
        return this.userAgentString.contains(MSIE8);
    }

    public boolean isIE9() {
        return this.userAgentString.contains(MSIE9);
    }

    public boolean isSafari() {
        return this.userAgentString.contains(SAFARI) && !this.userAgentString.contains(MOBILE_SAFARI) && !this.userAgentString.contains(CHROME);
    }

    public boolean isFirefox() {
        return this.userAgentString.contains(FIREFOX);
    }

    public boolean isChrome() {
        return this.userAgentString.contains(CHROME) && !this.userAgentString.contains(CHROMEFRAME);
    }

    public boolean isBrowserType(BrowserType browserType) {
        if (browserType == BrowserType.ALL) {
            return true;
        }
        if (browserType == BrowserType.ANDROID) {
            return this.isAndroidOS();
        }
        if (browserType == BrowserType.CHROME) {
            return this.isChrome();
        }
        if (browserType == BrowserType.FIREFOX) {
            return this.isFirefox();
        }
        if (browserType == BrowserType.IE) {
            return this.isIE();
        }
        if (browserType == BrowserType.IE7) {
            return this.isIE7();
        }
        if (browserType == BrowserType.IE8) {
            return this.isIE8();
        }
        if (browserType == BrowserType.IE8_OR_LESS) {
            return this.isIE8orLess();
        }
        if (browserType == BrowserType.IE9_OR_GREATER) {
            return !this.isIE8orLess();
        }
        if (browserType == BrowserType.IOS) {
            return this.isIOS();
        }
        if (browserType == BrowserType.SAFARI) {
            return this.isSafari();
        }
        return false;
    }

    public int getIEVersion() {
        try {
            Matcher versionMatcher = IE_VERSION_PATTERN.matcher(this.userAgentString);
            versionMatcher.find();
            return Integer.parseInt(versionMatcher.group(1));
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
    }
}

