if (!window.ice) {
    window.ice = new Object;
}
if (!window.ice.icefaces) {
    window.ice.globalEval = function(src) {
        if (window.execScript) {
            window.execScript(src);
        } else {
            (function() {
                window.eval.call(window, src);
            })();
        }
    };
    (function(namespace) {
        namespace.icefaces = true;
        namespace.configuration = new Object();
        namespace.disableDefaultErrorPopups = false;
        namespace.submitFunction = function (source, event, options) {
            jsf.ajax.request(source, event, options);
        };
        function detectByReference(ref) {
            return function(o) {
                return o == ref;
            };
        }
        function removeCallbackCallback(callbackList, detector) {
            return function removeCallback() {
                var temp = reject(callbackList, detector);
                empty(callbackList);
                each(temp, curry(append, callbackList));
            }
        }
        var sessionExpiryListeners = [];
        namespace.onSessionExpiry = function(callback) {
            append(sessionExpiryListeners, callback);
            return removeCallbackCallback(sessionExpiryListeners, detectByReference(callback));
        };
        var networkErrorListeners = [];
        namespace.onNetworkError = function(callback) {
            append(networkErrorListeners, callback);
            return removeCallbackCallback(networkErrorListeners, detectByReference(callback));
        };
        var serverErrorListeners = [];
        namespace.onServerError = function(callback) {
            append(serverErrorListeners, callback);
            return removeCallbackCallback(serverErrorListeners, detectByReference(callback));
        };
        var viewDisposedListeners = [];
        namespace.onViewDisposal = function(callback) {
            append(viewDisposedListeners, callback);
            return removeCallbackCallback(viewDisposedListeners, detectByReference(callback));
        };
        var beforeSubmitListeners = [];
        namespace.onBeforeSubmit = function(callback) {
            append(beforeSubmitListeners, callback);
            return removeCallbackCallback(beforeSubmitListeners, detectByReference(callback));
        };
        namespace.onSubmitSend = namespace.onBeforeSubmit;
        var beforeUpdateListeners = [];
        namespace.onBeforeUpdate = function(callback) {
            append(beforeUpdateListeners, callback);
            return removeCallbackCallback(beforeUpdateListeners, detectByReference(callback));
        };
        namespace.onSubmitResponse = namespace.onBeforeUpdate;
        var afterUpdateListeners = [];
        namespace.onAfterUpdate = function(callback) {
            append(afterUpdateListeners, callback);
            return removeCallbackCallback(afterUpdateListeners, detectByReference(callback));
        };
        function configurationOf(element) {
            var result = configurationOfImpl(element);
            if (result) {
                return result;
            }
            result = configurationOfImpl(document.getElementById(element.id));
            if (result) {
                return result;
            }
            debug(logger, 'configuration not found for ' + element.nodeName);
            return {};
        }
        function configurationOfImpl(element) {
            configParent = detect(parents(element),
                function(e) {
                    if (null != e) {
                        return e.configuration;
                    }
                    return {};
                });
            if (null != configParent) {
                return configParent.configuration;
            }
            return null;
        }
        function deltaSubmit(element) {
            return configurationOf(element).deltaSubmit;
        }
        function viewIDOf(element) {
            return configurationOf(element).viewID;
        }
        function formOf(element) {
            try {
                return formOfNode(element);
            } catch (e) {
                return formOfNode(document.getElementById(element.id));
            }
        }
        function formOfNode(element) {
            return toLowerCase(element.nodeName) == 'form' ? element : enclosingForm(element);
        }
        function lookupElementById(id) {
            var e;
            if (id == 'javax.faces.ViewRoot') {
                e = document.documentElement;
            } else if (id == 'javax.faces.ViewBody') {
                e = document.body;
            } else {
                try {
                    e = document.getElementById(id);
                } catch (e) {
                }
            }
            return e;
        }
        function lookupNamedInputElement(form, name) {
            var e = form[name];
            if (!e) {
                e = detect(form.getElementsByTagName('input'), function(input) {
                    return input.name && input.name == name;
                });
            }
            return e;
        }
        function lookupViewStateElement(element) {
            var e = lookupNamedInputElement(element, 'javax.faces.ViewState');
            if (e) {
                return e;
            } else {
                throw 'cannot find javax.faces.ViewState input element';
            }
        }
        function lookupViewState(element) {
            return lookupViewStateElement(element).value;
        }
        function retrieveUpdateFormID(viewID) {
            return viewID + '-retrieve-update';
        }
        function singleSubmitFormID(viewID) {
            return viewID + '-single-submit';
        }
function apply(fun, arguments) {
    return fun.apply(fun, arguments);
}
function withArguments() {
    var args = arguments;
    return function(fun) {
        apply(fun, args);
    };
}
function let(definition) {
    return function() {
        return apply(definition, arguments);
    };
}
function curry() {
    var args = arguments;
    return function() {
        var curriedArguments = [];
        var fun = args[0];
        for (var i = 1; i < args.length; i++) curriedArguments.push(args[i]);
        for (var j = 0; j < arguments.length; j++) curriedArguments.push(arguments[j]);
        return apply(fun, curriedArguments);
    };
}
function $witch(tests, defaultRun) {
    return function(val) {
        var args = arguments;
        var conditions = [];
        var runs = [];
        tests(function(condition, run) {
            conditions.push(condition);
            runs.push(run);
        });
        var size = conditions.length;
        for (var i = 0; i < size; i++) {
            if (apply(conditions[i], args)) {
                return apply(runs[i], args);
            }
        }
        if (defaultRun) apply(defaultRun, args);
    };
}
function identity(arg) {
    return arg;
}
function negate(b) {
    return !b;
}
function greater(a, b) {
    return a > b;
}
function less(a, b) {
    return a < b;
}
function not(a) {
    return !a;
}
function multiply(a, b) {
    return a * b;
}
function plus(a, b) {
    return a + b;
}
function max(a, b) {
    return a > b ? a : b;
}
function increment(value, step) {
    return value + (step ? step : 1);
}
function decrement(value, step) {
    return value - (step ? step : 1);
}
function any() {
    return true;
}
function none() {
    return false;
}
function noop() {
}
function isArray(a) {
    return a && !!a.push;
}
function isString(s) {
    return typeof s == 'string';
}
function isNumber(s) {
    return typeof s == 'number';
}
function isBoolean(s) {
    return typeof s == 'boolean';
}
function isIndexed(s) {
    return typeof s.length == 'number';
}
function isObject(o) {
    return o.instanceTag == o;
}
var uid = (function() {
    var id = 0;
    return function() {
        return id++;
    };
})();
function operationNotSupported() {
    throw 'operation not supported';
}
function operator(defaultOperation) {
    return function() {
        var args = arguments;
        var instance = arguments[0];
        if (instance.instanceTag && instance.instanceTag == instance) {
            var method = instance(arguments.callee);
            if (method) {
                return method.apply(method, args);
            } else {
                operationNotSupported();
            }
        } else {
            return defaultOperation ? defaultOperation.apply(defaultOperation, args) : operationNotSupported();
        }
    };
}
var asString = operator(String);
var asNumber = operator(Number);
var hash = operator(function(o) {
    var s;
    if (isString(o)) {
        s = o;
    } else if (isNumber(o)) {
        return Math.abs(Math.round(o));
    } else {
        s = o.toString();
    }
    var h = 0;
    for (var i = 0, l = s.length; i < l; i++) {
        var c = parseInt(s[i], 36);
        if (!isNaN(c)) {
            h = c + (h << 6) + (h << 16) - h;
        }
    }
    return Math.abs(h);
});
var equal = operator(function(a, b) {
    return a == b;
});
function object(definition) {
    var operators = [];
    var methods = [];
    var unknown = null;
    var id = uid();
    operators.push(hash);
    methods.push(function(self) {
        return id;
    });
    operators.push(equal);
    methods.push(function(self, other) {
        return self == other;
    });
    operators.push(asString);
    methods.push(function(self) {
        return 'Object:' + id.toString(16);
    });
    definition(function(operator, method) {
        var size = operators.length;
        for (var i = 0; i < size; i++) {
            if (operators[i] == operator) {
                methods[i] = method;
                return;
            }
        }
        operators.push(operator);
        methods.push(method);
    }, function(method) {
        unknown = method;
    });
    function self(operator) {
        var size = operators.length;
        for (var i = 0; i < size; i++) {
            if (operators[i] == operator) {
                return methods[i];
            }
        }
        return unknown;
    }
    return self.instanceTag = self;
}
function objectWithAncestors() {
    var definition = arguments[0];
    var args = arguments;
    var o = object(definition);
    function self(operator) {
        var method = o(operator);
        if (method) {
            return method;
        } else {
            var size = args.length;
            for (var i = 1; i < size; i++) {
                var ancestor = args[i];
                var overriddenMethod = ancestor(operator);
                if (overriddenMethod) {
                    return overriddenMethod;
                }
            }
            return null;
        }
    }
    return self.instanceTag = self;
}
var indexOf = operator($witch(function(condition) {
    condition(isString, function(items, item) {
        return items.indexOf(item);
    });
    condition(isArray, function(items, item) {
        for (var i = 0, size = items.length; i < size; i++) {
            if (items[i] == item) {
                return i;
            }
        }
        return -1;
    });
    condition(any, operationNotSupported);
}));
var concatenate = operator(function(items, other) {
    return items.concat(other);
});
var append = operator(function(items, item) {
    if (isArray(items)) {
        items.push(item);
        return items;
    } else {
        operationNotSupported();
    }
});
var insert = operator($witch(function(condition) {
    condition(isArray, function(items, item) {
        items.unshift(item);
        return items;
    });
    condition(any, operationNotSupported);
}));
var each = operator(function(items, iterator) {
    var size = items.length;
    for (var i = 0; i < size; i++) iterator(items[i], i);
});
var inject = operator(function(items, initialValue, injector) {
    var tally = initialValue;
    var size = items.length;
    for (var i = 0; i < size; i++) {
        tally = injector(tally, items[i]);
    }
    return tally;
});
var select = operator($witch(function(condition) {
    condition(isArray, function(items, selector) {
        return inject(items, [], function(tally, item) {
            return selector(item) ? append(tally, item) : tally;
        });
    });
    condition(isString, function(items, selector) {
        return inject(items, '', function(tally, item) {
            return selector(item) ? concatenate(tally, item) : tally;
        });
    });
    condition(isIndexed, function(items, selector) {
        return Stream(function(cellConstructor) {
            function selectingStream(start, end) {
                if (start > end) return null;
                var item = items[start];
                return selector(item) ?
                       function() {
                           return cellConstructor(item, selectingStream(start + 1, end));
                       } : selectingStream(start + 1, end);
            }
            return selectingStream(0, items.length - 1);
        });
    });
}));
var detect = operator(function(items, iterator, notDetectedThunk) {
    var size = items.length;
    for (var i = 0; i < size; i++) {
        var element = items[i];
        if (iterator(element, i)) {
            return element;
        }
    }
    return notDetectedThunk ? notDetectedThunk(items) : null;
});
var contains = operator($witch(function(condition) {
    condition(isString, function(items, item) {
        return items.indexOf(item) > -1;
    });
    condition(isArray, function(items, item) {
        var size = items.length;
        for (var i = 0; i < size; i++) {
            if (items[i] == item) {
                return true;
            }
        }
        return false;
    });
    condition(any, operationNotSupported);
}));
var size = operator(function(items) {
    return items.length;
});
var empty = operator(function(items) {
    items.length = 0;
});
var isEmpty = operator(function(items) {
    return items.length == 0;
});
var notEmpty = function(items) {
    return !isEmpty(items);
};
var collect = operator($witch(function(condition) {
    condition(isString, function(items, collector) {
        return inject(items, '', function(tally, item) {
            return concatenate(tally, collector(item));
        });
    });
    condition(isArray, function(items, collector) {
        return inject(items, [], function(tally, item) {
            return append(tally, collector(item));
        });
    });
    condition(isIndexed, function(items, collector) {
        return Stream(function(cellConstructor) {
            function collectingStream(start, end) {
                if (start > end) return null;
                return function() {
                    return cellConstructor(collector(items[start], start), collectingStream(start + 1, end));
                };
            }
            return collectingStream(0, items.length - 1);
        });
    });
}));
var sort = operator(function(items, sorter) {
    return copy(items).sort(function(a, b) {
        return sorter(a, b) ? -1 : 1;
    });
});
var reverse = operator(function(items) {
    return copy(items).reverse();
});
var copy = operator(function(items) {
    return inject(items, [], curry(append));
});
var join = operator(function(items, separator) {
    return items.join(separator);
});
var inspect = operator();
var reject = function(items, rejector) {
    return select(items, function(i) {
        return !rejector(i);
    });
};
var intersect = operator(function(items, other) {
    return select(items, curry(contains, other));
});
var complement = operator(function(items, other) {
    return reject(items, curry(contains, other));
});
var broadcast = function(items, args) {
    args = args || [];
    each(items, function(i) {
        apply(i, args);
    });
};
var broadcaster = function(items) {
    return function() {
        var args = arguments;
        each(items, function(i) {
            apply(i, args);
        });
    };
};
var asArray = function(items) {
    return inject(items, [], append);
};
var asSet = function(items) {
    return inject(items, [], function(set, item) {
        if (not(contains(set, item))) {
            append(set, item);
        }
        return set;
    });
};
var key = operator();
var value = operator();
function Cell(k, v) {
    return object(function(method) {
        method(key, function(self) {
            return k;
        });
        method(value, function(self) {
            return v;
        });
        method(asString, function(self) {
            return 'Cell[' + asString(k) + ': ' + asString(v) + ']';
        });
    });
}
function Stream(streamDefinition) {
    var stream = streamDefinition(Cell);
    return object(function(method) {
        method(each, function(self, iterator) {
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                iterator(key(cell));
                cursor = value(cell);
            }
        });
        method(inject, function(self, initialValue, injector) {
            var tally = initialValue;
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                tally = injector(tally, key(cell));
                cursor = value(cell);
            }
            return tally;
        });
        method(join, function(self, separator) {
            var tally;
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                var itemAsString = asString(key(cell));
                tally = tally ? tally + separator + itemAsString : itemAsString;
                cursor = value(cell);
            }
            return tally;
        });
        method(collect, function(self, collector) {
            return Stream(function(cellConstructor) {
                function collectingStream(stream) {
                    if (!stream) return null;
                    var cell = stream();
                    return function() {
                        return cellConstructor(collector(key(cell)), collectingStream(value(cell)));
                    };
                }
                return collectingStream(stream);
            });
        });
        method(contains, function(self, item) {
            var cursor = stream;
            while (cursor != null) {
                var cell = cursor();
                if (item == key(cell)) return true;
                cursor = value(cell);
            }
            return false;
        });
        method(size, function(self) {
            var cursor = stream;
            var i = 0;
            while (cursor != null) {
                i++;
                cursor = value(cursor());
            }
            return i;
        });
        method(select, function(self, selector) {
            return Stream(function(cellConstructor) {
                function select(stream) {
                    if (!stream) return null;
                    var cell = stream();
                    var k = key(cell);
                    var v = value(cell);
                    return selector(k) ? function() {
                        return cellConstructor(k, select(v));
                    } : select(v);
                }
                return select(stream);
            });
        });
        method(detect, function(self, detector, notDetectedThunk) {
            var cursor = stream;
            var result;
            while (cursor != null) {
                var cell = cursor();
                var k = key(cell);
                if (detector(k)) {
                    result = k;
                    break;
                }
                cursor = value(cell);
            }
            if (result) {
                return result;
            } else {
                return notDetectedThunk ? notDetectedThunk(self) : null;
            }
        });
        method(isEmpty, function(self) {
            return stream == null;
        });
        method(copy, function(self) {
            return Stream(streamDefinition);
        });
        method(asString, function(self) {
            return 'Stream[' + join(self, ', ') + ']';
        });
    });
}
var at = operator();
var putAt = operator();
var removeAt = operator();
var HashTable;
var HashSet;
(function() {
    var removeInArray = Array.prototype.splice ? function(array, index) {
        array.splice(index, 1);
    } : function(array, index) {
        if (index == array.length - 1) {
            array.length = index;
        } else {
            var rightSlice = array.slice(index + 1);
            array.length = index;
            for (var i = 0, l = rightSlice.length; i < l; ++i) {
                array[index + i] = rightSlice[i];
            }
        }
    };
    function atPrimitive(buckets, bucketCount, k, notFoundThunk) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    return entry.value;
                }
            }
            if (notFoundThunk) notFoundThunk();
            return null;
        } else {
            if (notFoundThunk) notFoundThunk();
            return null;
        }
    }
    function putAtPrimitive(buckets, bucketCount, k, v) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    var oldValue = entry.value;
                    entry.value = v;
                    return oldValue;
                }
            }
            bucket.push({ key:k, value: v });
            return null;
        } else {
            bucket = [
                {
                    key:k,
                    value: v
                }
            ];
            buckets[index] = bucket;
            return null;
        }
    }
    function removeAtPrimitive(buckets, bucketCount, k) {
        var index = hash(k) % bucketCount;
        var bucket = buckets[index];
        if (bucket) {
            for (var i = 0, l = bucket.length; i < l; i++) {
                var entry = bucket[i];
                if (equal(entry.key, k)) {
                    removeInArray(bucket, i);
                    if (bucket.length == 0) {
                        removeInArray(buckets, index);
                    }
                    return entry.value;
                }
            }
            return null;
        } else {
            return null;
        }
    }
    function injectPrimitive(buckets, initialValue, iterator) {
        var tally = initialValue;
        for (var i = 0, lbs = buckets.length; i < lbs; i++) {
            var bucket = buckets[i];
            if (bucket) {
                for (var j = 0, lb = bucket.length; j < lb; j++) {
                    var entry = bucket[j];
                    if (entry) {
                        tally = iterator(tally, entry.key, entry.value);
                    }
                }
            }
        }
        return tally;
    }
    var internalBuckets = operator();
    var internalBucketCount = operator();
    HashTable = function() {
        var buckets = [];
        var bucketCount = 5000;
        return object(function(method) {
            method(at, function(self, k, notFoundThunk) {
                return atPrimitive(buckets, bucketCount, k, notFoundThunk);
            });
            method(putAt, function(self, k, v) {
                return putAtPrimitive(buckets, bucketCount, k, v);
            });
            method(removeAt, function(self, k) {
                return removeAtPrimitive(buckets, bucketCount, k);
            });
            method(each, function(iterator) {
                injectPrimitive(buckets, null, function(tally, k, v) {
                    iterator(k, v);
                });
            });
        });
    };
    HashSet = function(list) {
        var buckets = [];
        var bucketCount = 5000;
        var present = new Object;
        if (list) {
            each(list, function(k) {
                putAtPrimitive(buckets, bucketCount, k, present);
            });
        }
        return object(function(method) {
            method(append, function(self, k) {
                putAtPrimitive(buckets, bucketCount, k, present);
            });
            method(each, function(self, iterator) {
                injectPrimitive(buckets, null, function(t, k, v) {
                    iterator(k);
                });
            });
            method(contains, function(self, k) {
                return !!atPrimitive(buckets, bucketCount, k);
            });
            method(complement, function(self, other) {
                var result = [];
                var c;
                try {
                    var othersInternalBuckets = internalBuckets(other);
                    var othersInternalBucketCount = internalBucketCount(other);
                    c = function(items, k) {
                        return !!atPrimitive(othersInternalBuckets, othersInternalBucketCount, k);
                    };
                } catch (e) {
                    c = contains;
                }
                return injectPrimitive(buckets, result, function(tally, k, v) {
                    if (!c(other, k)) {
                        result.push(k);
                    }
                    return tally;
                });
            });
            method(asString, function(self) {
                return 'HashSet[' + join(injectPrimitive(buckets, [], function(tally, k, v) {
                    tally.push(k);
                    return tally;
                }), ',') + ']';
            });
            method(internalBuckets, function(self) {
                return buckets;
            });
            method(internalBucketCount, function(self) {
                return bucketCount;
            });
        });
    };
})();
var indexOf = function(s, substring) {
    var index = s.indexOf(substring);
    if (index >= 0) {
        return index;
    } else {
        throw '"' + s + '" does not contain "' + substring + '"';
    }
};
var lastIndexOf = function(s, substring) {
    var index = s.lastIndexOf(substring);
    if (index >= 0) {
        return index;
    } else {
        throw 'string "' + s + '" does not contain "' + substring + '"';
    }
};
var startsWith = function(s, pattern) {
    return s.indexOf(pattern) == 0;
};
var endsWith = function(s, pattern) {
    return s.lastIndexOf(pattern) == s.length - pattern.length;
};
var containsSubstring = function(s, substring) {
    return s.indexOf(substring) >= 0;
};
var blank = function(s) {
    return /^\s*$/.test(s);
};
var split = function(s, separator) {
    return s.length == 0 ? [] : s.split(separator);
};
var replace = function(s, regex, replace) {
    return s.replace(regex, replace);
};
var toLowerCase = function(s) {
    return s.toLowerCase();
};
var toUpperCase = function(s) {
    return s.toUpperCase();
};
var substring = function(s, from, to) {
    return s.substring(from, to);
};
var trim = function(s) {
    s = s.replace(/^\s+/, '');
    for (var i = s.length - 1; i >= 0; i--) {
        if (/\S/.test(s.charAt(i))) {
            s = s.substring(0, i + 1);
            break;
        }
    }
    return s;
};
var asNumber = Number;
var asBoolean = function(s) {
    return 'true' == s || 'any' == s;
};
var asRegexp = function(s) {
    return new RegExp(s);
};
var run = operator();
var runOnce = operator();
var stop = operator();
function Delay(f, milliseconds) {
    return object(function(method) {
        var id = null;
        var canceled = false;
        method(run, function(self, times) {
            if (id || canceled) return;
            var call = times ? function() {
                try {
                    f();
                } finally {
                    if (--times < 1) stop(self);
                }
            } : f;
            id = setInterval(call, milliseconds);
            return self;
        });
        method(runOnce, function(self) {
            return run(self, 1);
        });
        method(stop, function(self) {
            if (id) {
                clearInterval(id);
                id = null;
            } else {
                canceled = true;
            }
        });
    });
}
function registerListener(eventType, obj, listener) {
    if (obj.addEventListener) {
        obj.addEventListener(eventType, listener, false);
        return function() {
            obj.removeEventListener(eventType, listener, false);
        }
    } else {
        var type = 'on' + eventType;
        obj.attachEvent(type, listener);
        return function() {
            obj.detachEvent(type, listener);
        }
    }
}
var onLoad = curry(registerListener, 'load');
var onUnload = curry(registerListener, 'unload');
var onBeforeUnload = curry(registerListener, 'beforeunload');
var onResize = curry(registerListener, 'resize');
var onKeyPress = curry(registerListener, 'keypress');
var onKeyUp = curry(registerListener, 'keyup');
window.width = function() {
    return window.innerWidth ? window.innerWidth : (document.documentElement && document.documentElement.clientWidth) ? document.documentElement.clientWidth : document.body.clientWidth;
};
window.height = function() {
    return window.innerHeight ? window.innerHeight : (document.documentElement && document.documentElement.clientHeight) ? document.documentElement.clientHeight : document.body.clientHeight;
};
        namespace.onLoad = curry(onLoad, window);
        namespace.onUnload = curry(onUnload, window);
        namespace.onPortletRemove = function(setupID, callback) {
            if (window.Liferay) {
                window.Liferay.bind('closePortlet', function (event) {
                    var container = document.getElementById('_' + event.portletId + '_');
                    var cursor = document.getElementById(setupID);
                    while (cursor) {
                        if (cursor == container) {
                            callback();
                            break;
                        } else {
                            cursor = cursor.parentNode;
                        }
                    }
                });
            }
        };
var cancel = operator();
var cancelBubbling = operator();
var cancelDefaultAction = operator();
var isKeyEvent = operator();
var isMouseEvent = operator();
var capturedBy = operator();
var triggeredBy = operator();
var serializeEventOn = operator();
var serializePositionOn = operator();
var type = operator();
var yes = any;
var no = none;
function isIEEvent(event) {
    return event.srcElement;
}
function Event(event, capturingElement) {
    return object(function (method) {
        method(cancel, function (self) {
            cancelBubbling(self);
            cancelDefaultAction(self);
        });
        method(isKeyEvent, no);
        method(isMouseEvent, no);
        method(type, function (self) {
            return event.type;
        });
        method(triggeredBy, function (self) {
            return capturingElement;
        });
        method(capturedBy, function (self) {
            return capturingElement;
        });
        method(serializeEventOn, function (self, query) {
            serializeElementOn(capturingElement, query);
            addNameValue(query, 'ice.event.target', identifier(triggeredBy(self)));
            addNameValue(query, 'ice.event.captured', identifier(capturedBy(self)));
            addNameValue(query, 'ice.event.type', 'on' + type(self));
        });
        method(serializeOn, curry(serializeEventOn));
    });
}
function IEEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        method(triggeredBy, function (self) {
            return event.srcElement ? event.srcElement : null;
        });
        method(cancelBubbling, function (self) {
            event.cancelBubble = true;
            if (event.stopPropagation) {
                event.stopPropagation();
            }
        });
        method(cancelDefaultAction, function (self) {
            event.returnValue = false;
            if (event.preventDefault) {
                event.preventDefault();
            }
        });
        method(asString, function (self) {
            return 'IEEvent[' + type(self) + ']';
        });
    }, Event(event, capturingElement));
}
function NetscapeEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        method(triggeredBy, function (self) {
            return event.target ? event.target : null;
        });
        method(cancelBubbling, function (self) {
            try {
                event.stopPropagation();
            } catch (e) {
            }
        });
        method(cancelDefaultAction, function (self) {
            try {
                event.preventDefault();
            } catch (e) {
            }
        });
        method(asString, function (self) {
            return 'NetscapeEvent[' + type(self) + ']';
        });
    }, Event(event, capturingElement));
}
var isAltPressed = operator();
var isCtrlPressed = operator();
var isShiftPressed = operator();
var isMetaPressed = operator();
var serializeKeyOrMouseEventOn = operator();
function KeyOrMouseEvent(event) {
    return object(function (method) {
        method(isAltPressed, function (self) {
            return event.altKey;
        });
        method(isCtrlPressed, function (self) {
            return event.ctrlKey;
        });
        method(isShiftPressed, function (self) {
            return event.shiftKey;
        });
        method(isMetaPressed, function (self) {
            return event.metaKey;
        });
        method(serializeKeyOrMouseEventOn, function (self, query) {
            addNameValue(query, 'ice.event.alt', isAltPressed(self));
            addNameValue(query, 'ice.event.ctrl', isCtrlPressed(self));
            addNameValue(query, 'ice.event.shift', isShiftPressed(self));
            addNameValue(query, 'ice.event.meta', isMetaPressed(self));
        });
    });
}
var isLeftButton = operator();
var isRightButton = operator();
var positionX = operator();
var positionY = operator();
var serializeMouseEventOn = operator();
function MouseEvent(event) {
    return objectWithAncestors(function (method) {
        method(isMouseEvent, yes);
        method(serializeMouseEventOn, function (self, query) {
            serializeKeyOrMouseEventOn(self, query);
            addNameValue(query, 'ice.event.x', positionX(self));
            addNameValue(query, 'ice.event.y', positionY(self));
            addNameValue(query, 'ice.event.left', isLeftButton(self));
            addNameValue(query, 'ice.event.right', isRightButton(self));
        });
    }, KeyOrMouseEvent(event));
}
function MouseEventTrait(method) {
    method(serializeOn, function (self, query) {
        serializeEventOn(self, query);
        serializeMouseEventOn(self, query);
    });
}
function IEMouseEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        MouseEventTrait(method);
        method(positionX, function (self) {
            return event.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft);
        });
        method(positionY, function (self) {
            return event.clientY + (document.documentElement.scrollTop || document.body.scrollTop);
        });
        method(isLeftButton, function (self) {
            return event.button == 1;
        });
        method(isRightButton, function (self) {
            return event.button == 2;
        });
        method(asString, function (self) {
            return 'IEMouseEvent[' + type(self) + ']';
        });
    }, MouseEvent(event), IEEvent(event, capturingElement));
}
function NetscapeMouseEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        MouseEventTrait(method);
        method(positionX, function (self) {
            return event.pageX;
        });
        method(positionY, function (self) {
            return event.pageY;
        });
        method(isLeftButton, function (self) {
            return event.which == 1;
        });
        method(isRightButton, function (self) {
            return event.which == 2;
        });
        method(asString, function (self) {
            return 'NetscapeMouseEvent[' + type(self) + ']';
        });
    }, MouseEvent(event), NetscapeEvent(event, capturingElement));
}
var keyCharacter = operator();
var keyCode = operator();
var serializeKeyEventOn = operator();
function KeyEvent(event) {
    return objectWithAncestors(function (method) {
        method(isKeyEvent, yes);
        method(keyCharacter, function (self) {
            return String.fromCharCode(keyCode(self));
        });
        method(serializeKeyEventOn, function (self, query) {
            serializeKeyOrMouseEventOn(self, query);
            addNameValue(query, 'ice.event.keycode', keyCode(self));
        });
    }, KeyOrMouseEvent(event));
}
function KeyEventTrait(method) {
    method(serializeOn, function (self, query) {
        serializeEventOn(self, query);
        serializeKeyEventOn(self, query);
    });
}
function IEKeyEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        KeyEventTrait(method);
        method(keyCode, function (self) {
            return event.keyCode;
        });
        method(asString, function (self) {
            return 'IEKeyEvent[' + type(self) + ']';
        });
    }, KeyEvent(event), IEEvent(event, capturingElement));
}
function NetscapeKeyEvent(event, capturingElement) {
    return objectWithAncestors(function (method) {
        KeyEventTrait(method);
        method(keyCode, function (self) {
            return event.which == 0 ? event.keyCode : event.which;
        });
        method(asString, function (self) {
            return 'NetscapeKeyEvent[' + type(self) + ']';
        });
    }, KeyEvent(event), NetscapeEvent(event, capturingElement));
}
function isEnterKey(event) {
    return keyCode(event) == 13;
}
function isEscKey(event) {
    return keyCode(event) == 27;
}
function UnknownEvent(capturingElement) {
    return objectWithAncestors(function (method) {
        method(cancelBubbling, noop);
        method(cancelDefaultAction, noop);
        method(type, function (self) {
            return 'unknown';
        });
        method(asString, function (self) {
            return 'UnkownEvent[]';
        });
    }, Event(null, capturingElement));
}
var MouseListenerNames = [ 'onclick', 'ondblclick', 'onmousedown', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup' ];
var KeyListenerNames = [ 'onkeydown', 'onkeypress', 'onkeyup', 'onhelp' ];
function $event(e, element) {
    var capturedEvent = e || window.event;
    if (capturedEvent && capturedEvent.type) {
        var eventType = 'on' + capturedEvent.type;
        if (contains(KeyListenerNames, eventType)) {
            return isIEEvent(capturedEvent) ? IEKeyEvent(capturedEvent, element) : NetscapeKeyEvent(capturedEvent, element);
        } else if (contains(MouseListenerNames, eventType)) {
            return isIEEvent(capturedEvent) ? IEMouseEvent(capturedEvent, element) : NetscapeMouseEvent(capturedEvent, element);
        } else {
            return isIEEvent(capturedEvent) ? IEEvent(capturedEvent, element) : NetscapeEvent(capturedEvent, element);
        }
    } else {
        return UnknownEvent(element);
    }
}
function identifier(element) {
    return element ? element.id : null;
}
function tag(element) {
    return toLowerCase(element.nodeName);
}
function property(element, name) {
    return element[name];
}
function parents(element) {
    return Stream(function(cellConstructor) {
        function parentStream(e) {
            if (e == null || e == document) return null;
            return function() {
                return cellConstructor(e, parentStream(e.parentNode));
            };
        }
        return parentStream(element.parentNode);
    });
}
function enclosingForm(element) {
    return element.form || detect(parents(element), function(e) {
        return tag(e) == 'form';
    }, function() {
        throw 'cannot find enclosing form';
    });
}
function enclosingBridge(element) {
    return property(detect(parents(element), function(e) {
        return property(e, 'bridge') != null;
    }, function() {
        throw 'cannot find enclosing bridge';
    }), 'bridge');
}
function serializeElementOn(element, query) {
    var tagName = tag(element);
    switch (tagName) {
        case 'a':
            var name = element.name || element.id;
            if (name) addNameValue(query, name, name);
            break;
        case 'input':
            switch (element.type) {
                case 'image':
                case 'submit':
                case 'button':
                    addNameValue(query, element.name, element.value);
                    break;
            }
            break;
        case 'button':
            if (element.type == 'submit') addNameValue(query, element.name, element.value);
            break;
        default:
    }
}
function $elementWithID(id) {
    return document.getElementById(id);
}
var debug = operator();
var info = operator();
var warn = operator();
var error = operator();
var childLogger = operator();
var log = operator();
var threshold = operator();
var enable = operator();
var disable = operator();
var toggle = operator();
function Logger(category, handler) {
    return object(function(method) {
        each([debug, info, warn, error], function(priorityOperator) {
            method(priorityOperator, function(self, message, exception) {
                log(handler, priorityOperator, category, message, exception);
            });
        });
        method(childLogger, function(self, categoryName, newHandler) {
            return Logger(append(copy(category), categoryName), newHandler || handler);
        });
        method(asString, function(self) {
            return 'Logger[' + join(category, '.') + ']';
        });
    });
}
function formatOutput(category, message) {
    var timestamp = (new Date()).toUTCString();
    return join(['[', join(category, '.'), '] [', timestamp, '] ', message], '');
}
function LocalStorageLogHandler(handler) {
    var enabled = false;
    if (window.addEventListener) {
        window.addEventListener('storage', function (e) {
            if (e.key == 'ice.localStorageLogHandler.enabled') {
                enabled = e.newValue == 'yes';
            }
        }, false);
    }
    function storeLogMessage(level, message, exception) {
        var previousMessages = localStorage['ice.localStorageLogHandler.store'] || '';
        var fullMessage = '[' + level + '] [' + ice.windowID + '] ' + message;
        if (exception) {
            fullMessage = fullMessage + '\n' + exception.message;
        }
        var messages = previousMessages + '%%' + fullMessage;
        var maxStorageUsed = localStorage['ice.localStorageLogHandler.maxSize'] || 500;
        var overflow = messages.length - maxStorageUsed * 1024;
        if (overflow > 0) {
            messages = messages.substr(overflow);
        }
        localStorage['ice.localStorageLogHandler.currentEntry'] = fullMessage;
        localStorage['ice.localStorageLogHandler.store'] = messages;
    }
    return object(function(method) {
        method(threshold, function(self, priority) {
            threshold(handler, priority);
        });
        method(log, function(self, operation, category, message, exception) {
            if (window.localStorage && (window.localStorage['ice.localStorageLogHandler.enabled'] || enabled)) {
                var formattedMessage = formatOutput(category, message);
                var priorityName;
                switch (operation) {
                    case debug:
                        priorityName = 'debug';
                        break;
                    case info:
                        priorityName = 'info ';
                        break;
                    case warn:
                        priorityName = 'warn ';
                        break;
                    case error:
                        priorityName = 'error';
                        break;
                    default:
                        priorityName = 'debug';
                }
                storeLogMessage(priorityName, formattedMessage, exception);
            }
            log(handler, operation, category, message, exception);
        });
    });
}
function ConsoleLogHandler(priority) {
    var ieConsole = !window.console.debug;
    var debugPrimitive = ieConsole ?
        function(self, category, message, exception) {
            exception ? console.log(formatOutput(category, message), '\n', exception) : console.log(formatOutput(category, message));
        } :
        function(self, category, message, exception) {
            exception ? console.debug(formatOutput(category, message), exception) : console.debug(formatOutput(category, message));
        };
    var infoPrimitive = ieConsole ?
        function(self, category, message, exception) {
            exception ? console.info(formatOutput(category, message), '\n', exception) : console.info(formatOutput(category, message));
        } :
        function(self, category, message, exception) {
            exception ? console.info(formatOutput(category, message), exception) : console.info(formatOutput(category, message));
        };
    var warnPrimitive = ieConsole ?
        function(self, category, message, exception) {
            exception ? console.warn(formatOutput(category, message), '\n', exception) : console.warn(formatOutput(category, message));
        } :
        function(self, category, message, exception) {
            exception ? console.warn(formatOutput(category, message), exception) : console.warn(formatOutput(category, message));
        };
    var errorPrimitive = ieConsole ?
        function(self, category, message, exception) {
            exception ? console.error(formatOutput(category, message), '\n', exception) : console.error(formatOutput(category, message));
        } :
        function(self, category, message, exception) {
            exception ? console.error(formatOutput(category, message), exception) : console.error(formatOutput(category, message));
        };
    var handlers = [
        Cell(debug, object(function(method) {
            method(debug, debugPrimitive);
            method(info, infoPrimitive);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(info, object(function(method) {
            method(debug, noop);
            method(info, infoPrimitive);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(warn, object(function(method) {
            method(debug, noop);
            method(info, noop);
            method(warn, warnPrimitive);
            method(error, errorPrimitive);
        })),
        Cell(error, object(function(method) {
            method(debug, noop);
            method(info, noop);
            method(warn, noop);
            method(error, errorPrimitive);
        }))
    ];
    var handler;
    function selectHandler(p) {
        handler = value(detect(handlers, function(cell) {
            return key(cell) == p;
        }));
    }
    selectHandler(priority || debug);
    return object(function (method) {
        method(threshold, function(self, priority) {
            selectHandler(priority);
        });
        method(log, function(self, operation, category, message, exception) {
            operation(handler, category, message, exception);
        });
    });
}
var FirebugLogHandler = ConsoleLogHandler;
function WindowLogHandler(thresholdPriority, name) {
    var lineOptions = [25, 50, 100, 200, 400];
    var numberOfLines = lineOptions[3];
    var categoryMatcher = /.*/;
    var closeOnExit = true;
    var logContainer;
    var logEntry = noop;
    function trimLines() {
        var nodes = logContainer.childNodes;
        var trim = size(nodes) - numberOfLines;
        if (trim > 0) {
            each(copy(nodes), function(node, index) {
                if (index < trim) logContainer.removeChild(node);
            });
        }
    }
    function trimAllLines() {
        each(copy(logContainer.childNodes), function(node) {
            logContainer.removeChild(node);
        });
    }
    function toggle() {
        var disabled = logEntry == noop;
        logEntry = disabled ? displayEntry : noop;
        return !disabled;
    }
    function displayEntry(priorityName, colorName, category, message, exception) {
        setTimeout(function(){
            try {
                var categoryName = join(category, '.');
                if (categoryMatcher.test(categoryName)) {
                    var elementDocument = logContainer.ownerDocument;
                    var timestamp = new Date();
                    var completeMessage = join(['[', categoryName, '] : ', message, (exception ? join(['\n', exception.name, ' <', exception.message, '>'], '') : '')], '');
                    each(split(completeMessage, '\n'), function(line) {
                        if (/(\w+)/.test(line)) {
                            var eventNode = elementDocument.createElement('div');
                            eventNode.style.padding = '3px';
                            eventNode.style.color = colorName;
                            eventNode.setAttribute("title", timestamp + ' | ' + priorityName);
                            logContainer.appendChild(eventNode).appendChild(elementDocument.createTextNode(line));
                        }
                    });
                    logContainer.scrollTop = logContainer.scrollHeight;
                }
                trimLines();
            } catch (ex) {
                logEntry = noop;
            }
        }, 1);
    }
    function showWindow() {
        var logWindow = window.open('', '_blank', 'scrollbars=1,width=800,height=680');
        try {
            var windowDocument = logWindow.document;
            var documentBody = windowDocument.body;
            each(copy(documentBody.childNodes), function(e) {
                windowDocument.body.removeChild(e);
            });
            documentBody.appendChild(windowDocument.createTextNode(' Close on exit '));
            var closeOnExitCheckbox = windowDocument.createElement('input');
            closeOnExitCheckbox.style.margin = '2px';
            closeOnExitCheckbox.setAttribute('type', 'checkbox');
            closeOnExitCheckbox.defaultChecked = true;
            closeOnExitCheckbox.checked = true;
            closeOnExitCheckbox.onclick = function() {
                closeOnExit = closeOnExitCheckbox.checked;
            };
            documentBody.appendChild(closeOnExitCheckbox);
            documentBody.appendChild(windowDocument.createTextNode(' Lines '));
            var lineCountDropDown = windowDocument.createElement('select');
            lineCountDropDown.style.margin = '2px';
            each(lineOptions, function(count, index) {
                var option = lineCountDropDown.appendChild(windowDocument.createElement('option'));
                if (numberOfLines == count) lineCountDropDown.selectedIndex = index;
                option.appendChild(windowDocument.createTextNode(asString(count)));
            });
            documentBody.appendChild(lineCountDropDown);
            documentBody.appendChild(windowDocument.createTextNode(' Category '));
            var categoryInputText = windowDocument.createElement('input');
            categoryInputText.style.margin = '2px';
            categoryInputText.setAttribute('type', 'text');
            categoryInputText.setAttribute('value', categoryMatcher.source);
            categoryInputText.onchange = function() {
                categoryMatcher = new RegExp(categoryInputText.value);
            };
            documentBody.appendChild(categoryInputText);
            documentBody.appendChild(windowDocument.createTextNode(' Level '));
            var levelDropDown = windowDocument.createElement('select');
            levelDropDown.style.margin = '2px';
            var levels = [Cell('debug', debug), Cell('info', info), Cell('warn', warn), Cell('error', error)];
            each(levels, function(priority, index) {
                var option = levelDropDown.appendChild(windowDocument.createElement('option'));
                if (thresholdPriority == value(priority)) levelDropDown.selectedIndex = index;
                option.appendChild(windowDocument.createTextNode(key(priority)));
            });
            levelDropDown.onchange = function(event) {
                thresholdPriority = value(levels[levelDropDown.selectedIndex]);
            };
            documentBody.appendChild(levelDropDown);
            var startStopButton = windowDocument.createElement('input');
            startStopButton.style.margin = '2px';
            startStopButton.setAttribute('type', 'button');
            startStopButton.setAttribute('value', 'Stop');
            startStopButton.onclick = function() {
                startStopButton.setAttribute('value', toggle() ? 'Stop' : 'Start');
            };
            documentBody.appendChild(startStopButton);
            var clearButton = windowDocument.createElement('input');
            clearButton.style.margin = '2px';
            clearButton.setAttribute('type', 'button');
            clearButton.setAttribute('value', 'Clear');
            documentBody.appendChild(clearButton);
            logContainer = documentBody.appendChild(windowDocument.createElement('pre'));
            logContainer.id = 'log-window';
            var logContainerStyle = logContainer.style;
            logContainerStyle.width = '100%';
            logContainerStyle.minHeight = '0';
            logContainerStyle.maxHeight = '550px';
            logContainerStyle.borderWidth = '1px';
            logContainerStyle.borderStyle = 'solid';
            logContainerStyle.borderColor = '#999';
            logContainerStyle.backgroundColor = '#ddd';
            logContainerStyle.overflow = 'scroll';
            lineCountDropDown.onchange = function(event) {
                numberOfLines = lineOptions[lineCountDropDown.selectedIndex];
                trimLines();
            };
            clearButton.onclick = trimAllLines;
            onUnload(window, function() {
                if (closeOnExit) {
                    logEntry = noop;
                    logWindow.close();
                }
            });
        } catch (e) {
            logWindow.close();
        }
    }
    onKeyUp(document, function(evt) {
        var event = $event(evt, document.documentElement);
        if (keyCode(event) == 84 && isCtrlPressed(event) && isShiftPressed(event)) {
            showWindow();
            logEntry = displayEntry;
        }
    });
    return object(function(method) {
        method(threshold, function(self, priority) {
            thresholdPriority = priority;
        });
        method(log, function(self, operation, category, message, exception) {
            operation(self, category, message, exception);
        });
        method(debug, function(self, category, message, exception) {
            logEntry('debug', '#333', category, message, exception);
        });
        method(info, function(self, category, message, exception) {
            logEntry('info', 'green', category, message, exception);
        });
        method(warn, function(self, category, message, exception) {
            logEntry('warn', 'orange', category, message, exception);
        });
        method(error, function(self, category, message, exception) {
            logEntry('error', 'red', category, message, exception);
        });
    });
}
        var handler = LocalStorageLogHandler(window.console && window.console.log ? ConsoleLogHandler(debug) : WindowLogHandler(debug, window.location.href));
        var logger = Logger([ 'icefaces' ], handler);
        namespace.log = logger;
        namespace.log.debug = debug;
        namespace.log.info = info;
        namespace.log.warn = warn;
        namespace.log.error = error;
        namespace.log.childLogger = childLogger;
var setFocus;
var applyFocus;
var currentFocus = '';
var monitorFocusChanges;
var restoreMonitorFocusChangesOnUpdate;
(function () {
    setFocus = function (id) {
        currentFocus = id ? id : '';
        debug(logger, 'persisted focus for element "' + id + '"');
    };
    function setCaretTo(element, pos) {
        if (element.createTextRange) {
            var range = element.createTextRange();
            range.move("character", pos);
            range.select();
        } else if (element.selectionStart || element.selectionStart == 0) {
            element.setSelectionRange(pos, pos);
        }
    }
    function setCaretAtTextEnd(element) {
        if ((toLowerCase(element.nodeName) == 'input' && element.type == 'text') || toLowerCase(element.nodeName) == 'textarea') {
            var text = element.value;
            setCaretTo(element, text.length);
        }
    }
    function isValidID(id) {
        return /^\w[\w\-\:]*$/.test(id);
    }
    var isIE = /MSIE/.test(navigator.userAgent);
    var focusOn = function (id) {
        runOnce(Delay(function () {
            if (id && isValidID(id)) {
                var e = document.getElementById(id);
                if (e && (e != document.activeElement)) {
                    setFocus(id);
                    if (e.focus) {
                        var x = window.scrollX || document.documentElement.scrollLeft;
                        var y = window.scrollY || document.documentElement.scrollTop;
                        try {
                            e.focus();
                            window.scrollTo(x, y);
                        } catch (ex) {
                        } finally {
                            if (isIE) {
                                try {
                                    e.focus();
                                    window.scrollTo(x, y);
                                } catch (ex2) {
                                }
                            }
                            debug(logger, 'focused element "' + id + '"');
                            setCaretAtTextEnd(e);
                        }
                    }
                }
            }
        }, 100));
    };
    var focusStrategy = focusOn;
    applyFocus = function (id) {
        focusStrategy(id);
    };
    if (isIE) {
        var activeElement;
        onLoad(window, function () {
            activeElement = document.activeElement;
        });
        var onBlur = function (callback) {
            registerElementListener(document, 'onfocusout', function () {
                if (activeElement == document.activeElement) {
                    callback();
                } else {
                    activeElement = document.activeElement;
                }
            });
        };
        var onFocus = function (callback) {
            registerElementListener(window, 'onfocus', callback);
        };
        onBlur(function () {
            focusStrategy = setFocus;
        });
        onFocus(function () {
            focusStrategy = focusOn;
        });
    }
    function registerElementListener(element, eventType, listener) {
        var previousListener = element[eventType];
        if (previousListener) {
            element[eventType] = function (e) {
                var args = [e];
                previousListener.apply(element, args);
                listener.apply(element, args);
            };
        } else {
            element[eventType] = listener;
        }
    }
    function saveCurrentFocus(e) {
        var evt = e || window.event;
        var element = evt.srcElement || evt.target;
        setFocus(element.id);
    }
    monitorFocusChanges = function(element) {
        if (element.attachEvent) {
            element.attachEvent('onfocusin', saveCurrentFocus);
        } else {
            element.addEventListener('focus', saveCurrentFocus, true);
            element.addEventListener('click', saveCurrentFocus, true);
        }
    };
    restoreMonitorFocusChangesOnUpdate = function(element) {
        var id = element.id;
        namespace.onAfterUpdate(function(updates) {
            if (detect(updates, function(update) {
                return update.getAttribute('id') == id;
            })) {
                monitorFocusChanges(lookupElementById(id));
            }
        });
    };
})();
        namespace.setFocus = setFocus;
        namespace.sf = setFocus;
        namespace.applyFocus = applyFocus;
        namespace.af = applyFocus;
var asURIEncodedString = operator();
var serializeOn = operator();
var Parameter = function(name, value) {
    return objectWithAncestors(function(method) {
        method(asURIEncodedString, function(self) {
            return encodeURIComponent(name) + '=' + encodeURIComponent(value);
        });
        method(serializeOn, function(self, query) {
            addParameter(query, self);
        });
    }, Cell(name, value));
};
var addParameter = operator();
var addNameValue = operator();
var queryParameters = operator();
var addQuery = operator();
var appendToURI = operator();
var Query = function() {
    var parameters = [];
    return object(function(method) {
        method(queryParameters, function(self) {
            return parameters;
        });
        method(addParameter, function(self, parameter) {
            append(parameters, parameter);
            return self;
        });
        method(addNameValue, function(self, name, value) {
            append(parameters, Parameter(name, value));
            return self;
        });
        method(addQuery, function(self, appended) {
            serializeOn(appended, self);
            return self;
        });
        method(serializeOn, function(self, query) {
            each(parameters, curry(addParameter, query));
        });
        method(asURIEncodedString, function(self) {
            return join(collect(parameters, asURIEncodedString), '&');
        });
        method(appendToURI, function(self, uri) {
            if (not(isEmpty(parameters))) {
                return uri + (contains(uri, '?') ? '&' : '?') + asURIEncodedString(self);
            } else {
                return uri;
            }
        });
        method(asString, function(self) {
            return inject(parameters, '', function(tally, p) {
                return tally + '|' + key(p) + '=' + value(p) + '|\n';
            });
        });
    });
};
var getSynchronously = operator();
var getAsynchronously = operator();
var postSynchronously = operator();
var postAsynchronously = operator();
var Client = function(autoclose) {
    var newNativeRequest;
    if (window.XMLHttpRequest) {
        newNativeRequest = function() {
            return new XMLHttpRequest();
        };
    } else if (window.ActiveXObject) {
        newNativeRequest = function() {
            return new window.ActiveXObject('Microsoft.XMLHTTP');
        };
    } else {
        throw 'cannot create XMLHttpRequest';
    }
    function withNewQuery(setup) {
        var query = Query();
        setup(query);
        return query;
    }
    var autoClose = autoclose ? close : noop;
    return object(function(method) {
        method(getAsynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('GET', appendToURI(withNewQuery(setupQuery), uri), true);
            setupRequest(request);
            nativeRequestResponse.onreadystatechange = function() {
                if (nativeRequestResponse.readyState == 4) {
                    onResponse(response, request);
                    autoClose(request);
                }
            };
            nativeRequestResponse.send('');
            return request;
        });
        method(getSynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('GET', appendToURI(withNewQuery(setupQuery), uri), false);
            setupRequest(request);
            nativeRequestResponse.send('');
            onResponse(response, request);
            autoClose(request);
        });
        method(postAsynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('POST', uri, true);
            setupRequest(request);
            nativeRequestResponse.onreadystatechange = function() {
                if (nativeRequestResponse.readyState == 4) {
                    onResponse(response, request);
                    autoClose(request);
                }
            };
            nativeRequestResponse.send(asURIEncodedString(withNewQuery(setupQuery)));
            return request;
        });
        method(postSynchronously, function(self, uri, setupQuery, setupRequest, onResponse) {
            var nativeRequestResponse = newNativeRequest();
            var request = RequestProxy(nativeRequestResponse);
            var response = ResponseProxy(nativeRequestResponse);
            nativeRequestResponse.open('POST', uri, false);
            setupRequest(request);
            nativeRequestResponse.send(asURIEncodedString(withNewQuery(setupQuery)));
            onResponse(response, request);
            autoClose(request);
        });
    });
};
var close = operator();
var abort = operator();
var setHeader = operator();
var onResponse = operator();
var RequestProxy = function(nativeRequestResponse) {
    return object(function(method) {
        method(setHeader, function(self, name, value) {
            nativeRequestResponse.setRequestHeader(name, value);
        });
        method(close, function(self) {
            nativeRequestResponse.onreadystatechange = noop;
        });
        method(abort, function(self) {
            nativeRequestResponse.onreadystatechange = noop;
            nativeRequestResponse.abort();
            method(abort, noop);
        });
    });
};
var statusCode = operator();
var statusText = operator();
var getHeader = operator();
var getAllHeaders = operator();
var hasHeader = operator();
var contentAsText = operator();
var contentAsDOM = operator();
var ResponseProxy = function(nativeRequestResponse) {
    return object(function(method) {
        method(statusCode, function() {
            try {
                return nativeRequestResponse.status;
            } catch (e) {
                return 0;
            }
        });
        method(statusText, function(self) {
            try {
                return nativeRequestResponse.statusText;
            } catch (e) {
                return '';
            }
        });
        method(hasHeader, function(self, name) {
            try {
                var header = nativeRequestResponse.getResponseHeader(name);
                return header && header != '';
            } catch (e) {
                return false;
            }
        });
        method(getHeader, function(self, name) {
            try {
                return nativeRequestResponse.getResponseHeader(name);
            } catch (e) {
                return null;
            }
        });
        method(getAllHeaders, function(self, name) {
            try {
                return collect(reject(split(nativeRequestResponse.getAllResponseHeaders(), '\n'), isEmpty), function(pair) {
                    var nameValue = split(pair, ': ')
                    return Cell(nameValue[0], nameValue[1]);
                });
            } catch (e) {
                return [];
            }
        });
        method(contentAsText, function(self) {
            try {
                return nativeRequestResponse.responseText;
            } catch (e) {
                return '';
            }
        });
        method(contentAsDOM, function(self) {
            try {
                return nativeRequestResponse.responseXML;
            } catch (e) {
                var txt = '<error>' + e + '</error>';
                var doc;
                if (window.DOMParser) {
                    var parser = new DOMParser();
                    doc = parser.parseFromString(txt,"text/xml");
                } else {
                    doc = new ActiveXObject("Microsoft.XMLDOM");
                    doc.async = false;
                    doc.loadXML(txt);
                }
                return doc;
            }
        });
        method(asString, function(self) {
            return inject(getAllHeaders(self), 'HTTP Response\n', function(result, header) {
                return result + key(header) + ': ' + value(header) + '\n';
            }) + contentAsText(self);
        });
    });
};
function OK(response) {
    return statusCode(response) == 200;
}
function NotFound(response) {
    return statusCode(response) == 404;
}
function ServerInternalError(response) {
    var code = statusCode(response);
    return code >= 500 && code < 600;
}
function FormPost(request) {
    setHeader(request, 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
}
        function appendHiddenInputElement(form, name, value, defaultValue) {
            var hiddenInput = document.createElement('input');
            hiddenInput.setAttribute('name', name);
            hiddenInput.setAttribute('value', value);
            hiddenInput.setAttribute('type', 'hidden');
            hiddenInput.setAttribute('autocomplete', 'off');
            if (defaultValue) {
                hiddenInput.defaultValue = defaultValue;
            }
            form.appendChild(hiddenInput);
            return hiddenInput;
        }
        function appendOrReplaceHiddenInputElement(form, name, value, defaultValue) {
            var element = form[name];
            if (!element) {
                appendHiddenInputElement(form, name, value, defaultValue);
            } else if (element.value != value) {
                element.parentNode.removeChild(element);
                appendHiddenInputElement(form, name, value, defaultValue);
            }
        }
        var viewIDs = [];
        function timedRetryAbort(retryAction, abortAction, timeouts) {
            var index = 0;
            var errorActions = inject(reverse(timeouts), [abortAction], function(actions, interval) {
                return insert(actions, curry(runOnce, Delay(retryAction, interval)));
            });
            return function() {
                if (index < errorActions.length) {
                    apply(errorActions[index], arguments);
                    index++;
                }
            };
        }
        function requestForUpdates(viewID, retries) {
            append(viewIDs, viewID);
            var formID = retrieveUpdateFormID(viewID);
            var form = lookupElementById(formID);
            appendOrReplaceHiddenInputElement(form, 'ice.view', viewID);
            appendOrReplaceHiddenInputElement(form, 'ice.window', namespace.window);
            if (form) {
                try {
                    debug(logger, 'picking updates for view ' + viewID);
                    var options = {
                        'ice.submit.type': 'ice.push',
                        execute: '@form',
                        render: '@all',
                        onerror: retries
                    };
                    jsf.ajax.request(form, null, options);
                } catch (e) {
                    warn(logger, 'failed to pick updates', e);
                }
            }
        }
        function retrieveUpdate(viewID, retryIntervals) {
            var delayedUpdates = function()  {
                if (eventInProgress)  {
                    setTimeout(delayedUpdates, 20);
                    return;
                }
                var retries = timedRetryAbort(function () {
                    info(logger, 'retrying to pick updates for view ' + viewID);
                    requestForUpdates(viewID, retries);
                }, broadcaster(networkErrorListeners), retryIntervals || [1000, 2000, 4000]);
                requestForUpdates(viewID, retries);
            };
            return delayedUpdates;
        }
        var client = Client();
        function disposeWindow(viewID) {
            return function() {
                var form = lookupElementById(singleSubmitFormID(viewID));
                if (form) {
                    try {
                        var encodedURLElement = lookupNamedInputElement(form, 'javax.faces.encodedURL');
                        var url = encodedURLElement ? encodedURLElement.value : form.action;
                        form.action = url.replace(/(\?|&)cid=[0-9]+/, "$1");
                        debug(logger, 'dispose window and associated views ' + viewIDs);
                        var querySetup = function(query) {
                            addNameValue(query, 'ice.submit.type', 'ice.dispose.window');
                            addNameValue(query, 'ice.window', namespace.window);
                            addNameValue(query, 'javax.faces.ViewState', lookupViewState(form));
                            each(viewIDs, curry(addNameValue, query, 'ice.view'));
                        };
                        if (navigator.sendBeacon) {
                            var parameters = [];
                            querySetup(object(function(method) {
                                method(addNameValue, function(self, name, value) {
                                    parameters.push(name + '=' + value);
                                });
                            }));
                            var data = parameters.join('&');
                            navigator.sendBeacon(form.action, new Blob([data], {type: 'application/x-www-form-urlencoded'}));
                        } else {
                            postSynchronously(client, form.action, querySetup, FormPost, noop);
                        }
                    } catch (e) {
                        warn(logger, 'failed to notify window disposal', e);
                    }
                }
            };
        }
        function sessionExpired() {
            requestForUpdates = noop;
            if (namespace.push) {
                each(viewIDs, namespace.push.deregister);
            }
            broadcast(sessionExpiryListeners);
        }
        function containsXMLData(doc) {
            return doc && doc.documentElement;
        }
        function containsHTMLData(doc) {
            return doc.documentElement.nodeName == 'html';
        }
        function submitEventBroadcaster(perRequestOnBeforeSubmitListeners, perRequestOnBeforeUpdateListeners, perRequestOnAfterUpdateListeners) {
            perRequestOnBeforeSubmitListeners = perRequestOnBeforeSubmitListeners || [];
            perRequestOnBeforeUpdateListeners = perRequestOnBeforeUpdateListeners || [];
            perRequestOnAfterUpdateListeners = perRequestOnAfterUpdateListeners || [];
            var viewID;
            return function(submitEvent) {
                var submitElement = submitEvent.source;
                if (submitElement) {
                    submitElement = lookupElementById(submitElement.id);
                    try {
                        viewID = viewIDOf(submitElement);
                    } catch (e) {
                    }
                    if (viewID) {
                        switch (submitEvent.status) {
                            case 'begin':
                                var isUserInitiatedRequest = false;
                                if (submitElement.id != retrieveUpdateFormID(viewIDOf(submitElement))) {
                                    isUserInitiatedRequest = true;
                                }
                                broadcast(perRequestOnBeforeSubmitListeners, [ submitElement, isUserInitiatedRequest ]);
                                break;
                            case 'complete':
                                var xmlContent = submitEvent.responseXML;
                                if (containsXMLData(xmlContent)) {
                                    if (containsHTMLData(xmlContent)) {
                                        document.location = document.location.href;
                                    } else {
                                        broadcast(perRequestOnBeforeUpdateListeners, [ xmlContent, submitElement ]);
                                    }
                                } else {
                                    warn(logger, 'the response does not contain XML data');
                                    if (configurationOf(submitElement).reloadOnUpdateFailure) {
                                        warn(logger, 'reloading page ...');
                                        document.location = document.location.href;
                                    }
                                }
                                break;
                            case 'success':
                                var xmlContent = submitEvent.responseXML;
                                broadcast(perRequestOnAfterUpdateListeners, [ xmlContent, submitElement ]);
                                break;
                        }
                    }
                } else {
                    warn(logger, 'Source element is undefined, cannot determine if this view is ICEfaces enabled.')
                }
            };
        }
        function submitErrorBroadcaster(perRequestNetworkErrorListeners, perRequestServerErrorListeners, sessionExpiredListener) {
            perRequestNetworkErrorListeners = perRequestNetworkErrorListeners || [];
            perRequestServerErrorListeners = perRequestServerErrorListeners || [];
            return function(e) {
                if (e.status == 'serverError') {
                    var xmlContent = e.responseXML;
                    if (containsXMLData(xmlContent) && sessionExpiredListener) {
                        var errorName = xmlContent.getElementsByTagName("error-name")[0].firstChild.nodeValue;
                        if (errorName && contains(errorName, 'org.icefaces.application.SessionExpiredException')) {
                            info(logger, 'received session expired message');
                            sessionExpiredListener();
                            return;
                        }
                    }
                    info(logger, 'received error message [code: ' + e.responseCode + ']: ' + e.responseText);
                    broadcast(perRequestServerErrorListeners, [ e.responseCode, e.responseText, containsXMLData(xmlContent) ? xmlContent : null]);
                } else if (e.status == 'httpError') {
                    warn(logger, 'HTTP error [code: ' + e.responseCode + ']: ' + e.description + '\n' + e.responseText);
                    if (not(e.source && containsSubstring(e.source.id, '-retrieve-update'))) {
                        broadcast(perRequestNetworkErrorListeners, [e.responseCode, e.description]);
                    }
                } else if (e.status == 'malformedXML') {
                    warn(logger, 'HTML parsing or JS evaluation error [code: ' + e.responseCode + ']: ' + e.description + '\n' + e.responseText);
                    if (e.responseCode > 200) {
                        broadcast(perRequestNetworkErrorListeners, [e.responseCode, e.description]);
                    }
                } else {
                    error(logger, 'Error [status: ' + e.status + ' code: ' + e.responseCode + ']: ' + e.description + '\n' + e.responseText);
                }
            };
        }
        namespace.submitCallback = submitEventBroadcaster(beforeSubmitListeners, beforeUpdateListeners, afterUpdateListeners);
        jsf.ajax.addOnEvent(namespace.submitCallback);
        namespace.errorCallback = submitErrorBroadcaster(networkErrorListeners, serverErrorListeners, sessionExpired);
        jsf.ajax.addOnError(namespace.errorCallback);
        var eventInProgress;
        function logReceivedUpdates(e) {
            if ('begin' == e.status)  {
                eventInProgress = e;
            } else {
                eventInProgress = null;
            }
            if ('success' == e.status) {
                var xmlContent = e.responseXML;
                var updates = xmlContent.documentElement.firstChild.childNodes;
                var updateDescriptions = collect(updates, function(update) {
                    var id = update.getAttribute('id');
                    var updateType = update.nodeName;
                    var detail = updateType + (id ? '["' + id + '"]' : '');
                    if ('update' == updateType) {
                        detail += ': ' + substring(update.firstChild.data, 0, 40) + '....';
                    } else if ('insert' == updateType) {
                        var location = update.firstChild.getAttribute('id');
                        var text = update.firstChild.firstChild.data;
                        detail += ': ' + update.firstChild.nodeName + ' ' + location + ': ' + substring(text, 0, 40) + '....';
                    } else if ('eval' == updateType) {
                        detail += ': ' + substring(update.firstChild.data, 0, 40) + '....';
                    }
                    return detail;
                });
                debug(logger, 'applied updates >>\n' + join(updateDescriptions, '\n'));
            }
        }
        jsf.ajax.addOnEvent(logReceivedUpdates);
var singleSubmitExecuteThis;
var singleSubmitExecuteThisRenderThis;
var submit;
var fullSubmit;
var singleSubmit;
(function() {
    function idOrElement(e) {
        return isString(e) ? document.getElementById(e) : e;
    }
    function formOf(element) {
        return toLowerCase(element.nodeName) == 'form' ? element : enclosingForm(element);
    }
    function isAjaxDisabled(formID, element) {
        var elementID = element.id;
        var disablingMarker = document.getElementById(formID + ":ajaxDisabled");
        return disablingMarker && contains(split(trim(disablingMarker.value), ' '), elementID);
    }
    function standardFormSerialization(element) {
        return configurationOf(element).standardFormSerialization;
    }
    function serializeEventToOptions(event, options) {
        var collectingQuery = object(function(method) {
            method(addNameValue, function(self, name, value) {
                options[name] = value;
            });
        });
        serializeOn(event, collectingQuery);
    }
    function encodedURLOf(form) {
        return form['javax.faces.encodedURL'] ? form['javax.faces.encodedURL'].value : form.action;
    }
    function serializeAdditionalParameters(additionalParameters, options) {
        if (additionalParameters) {
            additionalParameters(function(name, value) {
                options[name] = value;
            });
        }
    }
    function fixExecuteParameter(execute, element) {
        if (execute && element.name && element.id) {
            var execIds = execute.split(' ');
            for (var i = 0, size = execIds.length; i < size; i++) {
                if (execIds[i] == element.name) {
                    return execute;
                }
            }
            execute = execute + ' ' + element.name;
        }
        return execute;
    }
    singleSubmit = function(execute, render, event, element, additionalParameters, callbacks) {
        var viewID = viewIDOf(element);
        var form = document.getElementById(singleSubmitFormID(viewID));
        var clonedElements = [];
        try {
            var clonedElement = form.appendChild(element.cloneNode(true));
            append(clonedElements, clonedElement);
            var tagName = toLowerCase(element.nodeName);
            if (tagName == 'input') {
                if (element.type == 'radio') {
                    clonedElement.checked = element.checked;
                    execute = fixExecuteParameter(execute, element);
                }
                if (element.type == 'checkbox') {
                    clonedElement.checked = element.checked;
                    var name = element.name;
                    each(element.form.elements, function(checkbox) {
                        if (checkbox.name == name && checkbox != element) {
                            var checkboxClone = form.appendChild(checkbox.cloneNode(true));
                            append(clonedElements, checkboxClone);
                            checkboxClone.checked = checkbox.checked;
                        }
                    });
                    execute = fixExecuteParameter(execute, element);
                }
            } else if (tagName == 'select') {
                var clonedOptions = clonedElement.options;
                each(element.options, function(option, i) {
                    clonedOptions[i].selected = option.selected;
                });
            } else if (tagName == 'textarea') {
                clonedElement.value = element.value;
            }
            event = event || null;
            var onBeforeSubmitListeners = [];
            var onBeforeUpdateListeners = [];
            var onAfterUpdateListeners = [];
            var onNetworkErrorListeners = [];
            var onServerErrorListeners = [];
            if (callbacks) {
                callbacks(
                    curry(append, onBeforeSubmitListeners),
                    curry(append, onBeforeUpdateListeners),
                    curry(append, onAfterUpdateListeners),
                    curry(append, onNetworkErrorListeners),
                    curry(append, onServerErrorListeners)
                );
            }
            if (deltaSubmit(element)) {
                append(onAfterUpdateListeners, recalculateFormPreviousParameters(element, form));
            }
            var requestScopedSubmitEventBroadcaster = submitEventBroadcaster(onBeforeSubmitListeners, onBeforeUpdateListeners, onAfterUpdateListeners);
            var requestScopedSubmitErrorBroadcaster = submitErrorBroadcaster(onNetworkErrorListeners, onServerErrorListeners);
            var options = {
                execute: execute,
                render: render,
                onevent: requestScopedSubmitEventBroadcaster,
                onerror: requestScopedSubmitErrorBroadcaster,
                'ice.window': namespace.window,
                'ice.view': viewID,
                'ice.focus': currentFocus
            };
            var decoratedEvent = $event(event, element);
            if (isKeyEvent(decoratedEvent) && isEnterKey(decoratedEvent)) {
                cancelBubbling(decoratedEvent);
                cancelDefaultAction(decoratedEvent);
            }
            serializeEventToOptions(decoratedEvent, options);
            serializeAdditionalParameters(additionalParameters, options);
            debug(logger, join([
                'partial submit to ' + encodedURLOf(form),
                'javax.faces.execute: ' + execute,
                'javax.faces.render: ' + render,
                'javax.faces.source: ' + element.id,
                'view ID: ' + viewID,
                'event type: ' + type(decoratedEvent)
            ], '\n'));
            namespace.submitFunction(clonedElement, event, options);
        } catch (e) {
            debug(logger, "singleSubmit failed " + e);
        } finally {
            if (window.myfaces) {
                append(onAfterUpdateListeners, function() {
                    each(clonedElements, function(c) {
                        form.removeChild(c);
                    });
                });
            } else {
                each(clonedElements, function(c) {
                    form.removeChild(c);
                });
            }
        }
    }
    singleSubmitExecuteThis = function(event, idorelement, additionalParameters, callbacks) {
        var element = idOrElement(idorelement);
        if (standardFormSerialization(element)) {
            return fullSubmit('@this', '@all', event, element, function(p) {
                p('ice.submit.type', 'ice.se');
                p('ice.submit.serialization', 'form');
                if (additionalParameters) additionalParameters(p);
            }, callbacks);
        } else {
            return singleSubmit('@this', '@all', event, element, function(p) {
                p('ice.submit.type', 'ice.se');
                p('ice.submit.serialization', 'element');
                if (additionalParameters) additionalParameters(p);
            }, callbacks);
        }
    };
    singleSubmitExecuteThisRenderThis = function(event, idorelement, additionalParameters, callbacks) {
        var element = idOrElement(idorelement);
        if (standardFormSerialization(element)) {
            return fullSubmit('@this', '@this', event, element, function(p) {
                p('ice.submit.type', 'ice.ser');
                p('ice.submit.serialization', 'form');
                if (additionalParameters) additionalParameters(p);
            }, callbacks);
        } else {
            return singleSubmit('@this', '@this', event, element, function(p) {
                p('ice.submit.type', 'ice.ser');
                p('ice.submit.serialization', 'element');
                if (additionalParameters) additionalParameters(p);
            }, callbacks);
        }
    };
    var addPrefix = 'patch+';
    var removePrefix = 'patch-';
    function extractTarget(e) {
        if (!e) {
            return null;
        }
        return (e.currentTarget) ? e.currentTarget :
            ( (e.target) ? e.target : e.srcElement );
    }
    function isFormElement(e) {
        var type = toLowerCase(e.nodeName);
        return (type == 'input' && (e.name != 'javax.faces.ViewState')) ||
            type == 'select' ||
            type == 'textarea';
    }
    function recalculateFormPreviousParameters(element, form) {
        return function(updates) {
            var updatedFragments = inject(updates.getElementsByTagName('update'), [], function(result, update) {
                var id = update.getAttribute('id');
                if (contains(id, 'javax.faces.ViewState') || endsWith(id, '_fixviewstate')) {
                    return result;
                } else {
                    return append(result, lookupElementById(id));
                }
            });
            var updatedForms = inject(updatedFragments, [ form ] , function(result, e) {
                if (isFormElement(e) && not(contains(result, e.form))) {
                    append(result, e.form);
                } else {
                    each(e.getElementsByTagName('form'), function(form) {
                        append(result, form);
                    });
                }
                return result;
            });
            each(updatedForms, function(form) {
                debug(logger, 'recalculate initial parameters for updated form["' + form.id + '"]');
                form.previousParameters = HashSet(jsf.getViewState(form).split('&'));
            });
        };
    }
    fullSubmit = function(execute, render, event, element, additionalParameters, callbacks) {
        var f = null;
        var extractedElement = extractTarget(event);
        var eventElement = (extractedElement) ? extractedElement :
            triggeredBy($event(event, element));
        if (eventElement && (eventElement.tagName) &&
            (toLowerCase(eventElement.tagName) == "form")) {
            eventElement = element;
        }
        if (toLowerCase(element.tagName) == "form") {
            f = element;
        } else {
            f = formOf(element);
        }
        var formID = f.id;
        var ajaxIsDisabled = false;
        var ancestor = eventElement;
        while (null != ancestor) {
            if ((ancestor.tagName) &&
                (toLowerCase(ancestor.tagName) == "form")) {
                break;
            }
            if (isAjaxDisabled(formID, ancestor)) {
                ajaxIsDisabled = true;
                break;
            }
            ancestor = ancestor.parentNode;
        }
        if (ajaxIsDisabled) {
            if (f && f.nativeSubmit) {
                var fakeClick = document.createElement("input");
                fakeClick.setAttribute("type", "hidden");
                fakeClick.setAttribute("name", eventElement.name);
                fakeClick.setAttribute("value", eventElement.value);
                fakeClick.setAttribute("autocomplete", "off");
                f.appendChild(fakeClick);
                f.nativeSubmit();
                f.removeChild(fakeClick);
            }
        } else {
            event = event || null;
            var onBeforeSubmitListeners = [];
            var onBeforeUpdateListeners = [];
            var onAfterUpdateListeners = [];
            var onNetworkErrorListeners = [];
            var onServerErrorListeners = [];
            if (callbacks) {
                callbacks(
                    curry(append, onBeforeSubmitListeners),
                    curry(append, onBeforeUpdateListeners),
                    curry(append, onAfterUpdateListeners),
                    curry(append, onNetworkErrorListeners),
                    curry(append, onServerErrorListeners)
                );
            }
            var viewID = viewIDOf(element);
            var requestScopedSubmitEventBroadcaster = submitEventBroadcaster(onBeforeSubmitListeners, onBeforeUpdateListeners, onAfterUpdateListeners);
            var requestScopedSubmitErrorBroadcaster = submitErrorBroadcaster(onNetworkErrorListeners, onServerErrorListeners);
            var options = {
                execute: execute,
                render: render,
                onevent: requestScopedSubmitEventBroadcaster,
                onerror: requestScopedSubmitErrorBroadcaster,
                'ice.window': namespace.window,
                'ice.view': viewID,
                'ice.focus': currentFocus};
            var decoratedEvent = $event(event, element);
            if (isKeyEvent(decoratedEvent) && isEnterKey(decoratedEvent)) {
                cancelBubbling(decoratedEvent);
                cancelDefaultAction(decoratedEvent);
            }
            try {
                serializeEventToOptions(decoratedEvent, options);
            } catch (e) {
                debug(logger, "Unable to serialize event " + e);
            }
            serializeAdditionalParameters(additionalParameters, options);
            var form = formOf(element);
            var isDeltaSubmit = deltaSubmit(element);
            debug(logger, join([
                (isDeltaSubmit ? 'delta ' : '') + 'full submit to ' + encodedURLOf(form),
                'javax.faces.execute: ' + execute,
                'javax.faces.render: ' + render,
                'javax.faces.source: ' + element.id,
                'view ID: ' + viewID,
                'event type: ' + type(decoratedEvent)
            ], '\n'));
            if (isDeltaSubmit) {
                append(onAfterUpdateListeners, recalculateFormPreviousParameters(element, f));
                var previousParameters = form.previousParameters || HashSet();
                var currentParameters = HashSet(jsf.getViewState(form).split('&'));
                var addedParameters = complement(currentParameters, previousParameters);
                var removedParameters = complement(previousParameters, currentParameters);
                function splitStringParameter(f) {
                    return function(p) {
                        var parameter = split(p, '=');
                        f(decodeURIComponent(parameter[0]), decodeURIComponent(parameter[1]));
                    };
                }
                var deltaSubmitForm = document.getElementById(singleSubmitFormID(viewID));
                var appendedElements = [];
                var clonedElement;
                if (toLowerCase(element.nodeName) == 'form') {
                    clonedElement = document.createElement('input');
                    clonedElement.setAttribute('id', element.id);
                    clonedElement.setAttribute('name', element.id);
                    clonedElement.setAttribute('value', element.id);
                    clonedElement.setAttribute('type', 'hidden');
                    clonedElement.setAttribute('autocomplete', 'off');
                } else {
                    clonedElement = element.cloneNode(true);
                    clonedElement.value = element.value;
                }
                clonedElement._original = element;
                append(appendedElements, deltaSubmitForm.appendChild(clonedElement));
                function createHiddenInputInDeltaSubmitForm(name, value) {
                    append(appendedElements, appendHiddenInputElement(deltaSubmitForm, name, value));
                }
                try {
                    createHiddenInputInDeltaSubmitForm('ice.deltasubmit.form', form.id);
                    createHiddenInputInDeltaSubmitForm(form.id, form.id);
                    each(addedParameters, splitStringParameter(function(name, value) {
                        createHiddenInputInDeltaSubmitForm(addPrefix + name, value);
                    }));
                    each(removedParameters, splitStringParameter(function(name, value) {
                        createHiddenInputInDeltaSubmitForm(removePrefix + name, value);
                    }));
                    namespace.submitFunction(clonedElement, event, options);
                } finally {
                    each(appendedElements, function(element) {
                        deltaSubmitForm.removeChild(element);
                    });
                }
            } else {
                namespace.submitFunction(element, event, options);
            }
        }
    };
    submit = function(event, element, additionalParameters, callbacks) {
        return fullSubmit('@all', '@all', event, idOrElement(element), function(p) {
            p('ice.submit.type', 'ice.s');
            p('ice.submit.serialization', 'form');
            if (additionalParameters) additionalParameters(p);
        }, callbacks);
    };
})();
var startBlockingUI;
(function() {
    var off = operator();
    function Overlay(element) {
        var container = element || document.body;
        var overlay = container.ownerDocument.createElement('iframe');
        overlay.setAttribute('src', 'about:blank');
        overlay.setAttribute('frameborder', '0');
        var overlayStyle = overlay.style;
        overlayStyle.position = 'absolute';
        overlayStyle.filter = 'alpha(opacity=0)';
        overlayStyle.top = '0';
        overlayStyle.left = '0';
        overlayStyle.zIndex = 3000;
        var stylingOverlay = container.ownerDocument.createElement('div');
        stylingOverlay.className = 'ice-blockui-overlay';
        var stylingOverlayStyle = stylingOverlay.style;
        stylingOverlayStyle.position = 'absolute';
        stylingOverlayStyle.top = '0';
        stylingOverlayStyle.left = '0';
        stylingOverlayStyle.zIndex = 3001;
        if (container.tagName.toLowerCase() == 'body') {
            overlayStyle.width = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth) + 'px';
            overlayStyle.height = Math.max(document.documentElement.offsetHeight, document.documentElement.scrollHeight, document.body.scrollHeight) + 'px';
            stylingOverlayStyle.width = overlayStyle.width;
            stylingOverlayStyle.height = overlayStyle.height;
        } else {
            overlayStyle.width = container.offsetWidth + 'px';
            overlayStyle.height = container.offsetHeight + 'px';
            stylingOverlayStyle.width = overlayStyle.width;
            stylingOverlayStyle.height = overlayStyle.height;
        }
        container.appendChild(overlay);
        container.appendChild(stylingOverlay);
        return object(function(method) {
            method(off, function(self) {
                if (overlay) {
                    try {
                        container.removeChild(overlay);
                        container.removeChild(stylingOverlay);
                    } catch (e) {
                    }
                }
            });
        });
    }
    function isBlockUIEnabled(source) {
        return configurationOf(source).blockUIOnSubmit;
    }
    function eventSink(element) {
        return function(e) {
            var ev = $event(e, element);
            var evenType = type(ev);
            var triggeringElement = triggeredBy(ev);
            var capturingElement = capturedBy(ev);
            cancel(ev);
            debug(logger, 'event [type: ' + evenType +
                ', triggered by: ' + (identifier(triggeringElement) || triggeringElement) +
                ', captured in: ' + (identifier(capturingElement) || capturingElement) + '] was discarded.');
        }
    }
    function isBlurEvent() {
        var c = arguments.callee.caller;
        while (c) {
            if (c == namespace.fullSubmit) {
                var eventArgument = c.arguments[2];
                if (eventArgument)  {
                    return eventArgument.type == 'blur';
                } else {
                    return false;
                }
            }
            try {
                c = c.arguments.callee.caller;
            } catch (ex) {
                break;
            }
        }
        return false;
    }
    startBlockingUI = function() {
        debug(logger, 'blocking UI');
        var blockUIOverlay = Overlay();
        var rollbacks = inject(['input', 'select', 'textarea', 'button', 'a'], [], function(result, type) {
            return concatenate(result, asArray(collect(document.body.getElementsByTagName(type), function(e) {
                var sink = eventSink(e);
                var onkeypress = e.onkeypress;
                var onkeyup = e.onkeyup;
                var onkeydown = e.onkeydown;
                var onclick = e.onclick;
                e.onkeypress = sink;
                e.onkeyup = sink;
                e.onkeydown = sink;
                e.onclick = sink;
                return function() {
                    try {
                        e.onkeypress = onkeypress;
                        e.onkeyup = onkeyup;
                        e.onkeydown = onkeydown;
                        e.onclick = onclick;
                    } catch (ex) {
                    }
                };
            })));
        });
        return function() {
            broadcast(rollbacks);
            off(blockUIOverlay);
            debug(logger, 'unblocked UI');
        };
    };
    var lock = false;
    var originalSubmitFunction = ice.submitFunction;
    ice.submitFunction = function(element, event, options) {
        if (isBlockUIEnabled(element) && not(isBlurEvent())) {
            if (!lock) {
                lock = true;
                var originalOnEvent = options.onevent;
                options.onevent = function (submitEvent) {
                    if (submitEvent.status == 'success') {
                        lock = false;
                    }
                    if (originalOnEvent) {
                        originalOnEvent(submitEvent);
                    }
                };
                originalSubmitFunction(element, event, options);
            }
        } else {
            originalSubmitFunction(element, event, options);
        }
    };
    var stopBlockingUI = noop;
    namespace.onBeforeSubmit(function(source, isClientRequest) {
        if (isClientRequest && isBlockUIEnabled(source) && not(isBlurEvent())) {
            stopBlockingUI = startBlockingUI();
        } else {
            stopBlockingUI = noop;
        }
    });
    namespace.onBeforeUpdate(function() {
        stopBlockingUI();
    });
})();
        namespace.se = singleSubmitExecuteThis;
        namespace.ser = singleSubmitExecuteThisRenderThis;
        namespace.submit = submit;
        namespace.s = submit;
        namespace.fullSubmit = fullSubmit;
        namespace.ajaxRefresh = function(viewID, retryIntervals) {
            viewID = viewID || (document.body.configuration ? document.body.configuration.viewID : null);
            if (!viewID) {
                throw 'viewID parameter required';
            }
            var c = configurationOf(lookupElementById(retrieveUpdateFormID(viewID)));
            if (!c.ajaxRefresh) {
                c.ajaxRefresh = retrieveUpdate(viewID, retryIntervals);
            }
            c.ajaxRefresh();
        };
        namespace.setupBridge = function(setupID, viewID, windowID, configuration) {
            var container = document.getElementById(setupID).parentNode;
            container.setupCount = container.setupCount ? (container.setupCount + 1) : 1;
            if (container.setupCount == 1) {
                container.configuration = configuration;
                container.configuration.viewID = viewID;
                namespace.window = windowID;
                if (configuration.sendDisposeWindow) {
                    onBeforeUnload(window, disposeWindow(viewID));
                }
                if (configuration.focusManaged) {
                    monitorFocusChanges(container);
                    restoreMonitorFocusChangesOnUpdate(container);
                }
                if (configuration.clientSideElementUpdateDetermination) {
                    switchToClientSideElementUpdateDetermination();
                }
                if (configuration.blockUIOnSubmit) {
                    onBeforeUnload(window, function() {
						if (!ice.preventBlockingUI) {
							startBlockingUI();
						}
                    });
                }
                if (configuration.urlBasedWindowTracking) {
                    function clone(o) {
                        var c = 'function' === typeof o.pop ? [] : {};
                        for (var name in o) {
                            if(o.hasOwnProperty(name)) {
                                c[name] = o[name];
                            }
                        }
                        return c;
                    }
                    function appendWindowIdToURL() {
                        if (window.location.search.indexOf('jfwid=' + windowID) < 0) {
                            var path = window.location.search ? [window.location.pathname, window.location.search, '&jfwid=', windowID].join('') : [window.location.pathname, '?jfwid=', windowID].join('');
                            var state = window.history.state ? clone(window.history.state) : {};
                            window.history.replaceState(state, window.document.title, path);
                        }
                    }
                    namespace.onLoad(appendWindowIdToURL);
                    namespace.onAfterUpdate(appendWindowIdToURL);
                }
                setupDefaultIndicators(container, configuration);
                clearEventHandlersOnUnload(container);
            }
        };
        namespace.setupPush = function(setupID, viewID, retryIntervals, fetchPendingNotifications) {
            var intervals = asArray(collect(split(retryIntervals, ' '), Number));
            var retrieveViewUpdate = retrieveUpdate(viewID, intervals);
            ice.push.register([viewID], retrieveViewUpdate);
            if (fetchPendingNotifications) {
                ice.onBlockingConnectionReEstablished(retrieveViewUpdate);
            }
            var unsetupPush = curry(namespace.unsetupPush, viewID);
            namespace.onSessionExpiry(unsetupPush);
            namespace.onNetworkError(unsetupPush);
            namespace.onServerError(unsetupPush);
            namespace.onUnload(unsetupPush);
            namespace.onPortletRemove(setupID, unsetupPush);
        };
        namespace.unsetupPush = function(viewID) {
            ice.push.deregister([viewID]);
        };
        namespace.setupRefresh = function(viewID, interval, duration, id, retryIntervals) {
            var times = duration < 0 ? null : Math.floor(duration / interval);
            var intervals = asArray(collect(split(retryIntervals, ' '), Number));
            var requestUpdate = retrieveUpdate(viewID, intervals);
            var delay = Delay(requestUpdate, interval);
            run(delay, times);
            var stopDelay = curry(stop, delay);
            namespace.onSessionExpiry(stopDelay);
            namespace.onNetworkError(stopDelay);
            namespace.onServerError(stopDelay);
            namespace.onUnload(stopDelay);
            namespace.onElementUpdate(id, stopDelay);
        };
        namespace.calculateInitialParameters = function(id) {
            var f = document.getElementById(id);
            f.previousParameters = HashSet(jsf.getViewState(f).split('&'));
        };
        onBeforeUnload(window, function() {
            empty(networkErrorListeners);
        });
        onKeyPress(document, function(ev) {
            var e = $event(ev);
            if (isEscKey(e)) cancelDefaultAction(e);
        });
(function() {
    var beforeSessionExpiryListeners = [];
    namespace.onBeforeSessionExpiry = function(callback) {
        append(beforeSessionExpiryListeners, callback);
        return removeCallbackCallback(beforeSessionExpiryListeners, detectByReference(callback));
    };
    var beforeSessionExpiryTimeoutBomb = object(function(method) {
        method(stop, noop);
    });
    var sessionExpiryTimeoutBomb = object(function(method) {
        method(stop, noop);
    });
    namespace.resetSessionExpiryTimeout = function(deltaTime, timeLeft) {
        stop(beforeSessionExpiryTimeoutBomb);
        stop(sessionExpiryTimeoutBomb);
        var timeInSeconds = Math.round(timeLeft / 1000);
        beforeSessionExpiryTimeoutBomb = runOnce(Delay(function() {
            broadcast(beforeSessionExpiryListeners, [timeInSeconds]);
            runOnce(Delay(function() {
                sessionExpiryTimeoutBomb = broadcast(sessionExpiryListeners);
            }, timeLeft));
        }, deltaTime));
    };
})();
var clearEventHandlersOnUnload;
(function() {
    function clearEventHandlers(element) {
        element.onkeypress = null;
        element.onmousedown = null;
        element.onmousemove = null;
        element.onmouseout = null;
        element.onmouseover = null;
        element.onclick = null;
        element.oncontextmenu = null;
        element.onchange = null;
        element.onfocus = null;
        element.onblur = null;
        element.submit = null;
        element.onsubmit = null;
        element.onkeydown = null;
        element.onkeyup = null;
        element.ondblclick = null;
        element.onfocusout = null;
    }
    clearEventHandlersOnUnload = function(container) {
        onUnload(window, function() {
            container.configuration = null;
            each(['a', 'iframe'], function(type) {
                each(container.getElementsByTagName(type), clearEventHandlers);
            });
            each(container.getElementsByTagName('form'), function(form) {
                try {
                    form.submit = null;
                } catch (ex) {
                }
                form.onsubmit = null;
                var elements = form.elements;
                if (elements) {
                    each(elements, clearEventHandlers);
                }
            });
        });
    };
    namespace.onBeforeUpdate(function(updates) {
        each(updates.getElementsByTagName('update'), function(update) {
            var id = update.getAttribute('id');
            var e = lookupElementById(id);
            if (e) {
                clearEventHandlers(e);
                each(['a', 'iframe', 'input', 'select', 'button', 'textarea'], function(type) {
                    each(e.getElementsByTagName(type), clearEventHandlers);
                });
                each(e.getElementsByTagName('form'), function(form) {
                    clearEventHandlers(form);
                    form.submit = null;
                    form.onsubmit = null;
                });
            }
        });
    });
})();
(function() {
    namespace.captureKeypress = function(id, keyMap) {
        var f = document.getElementById(id);
        var captureKeypress = function(ev) {
            var e = $event(ev, f);
            var element = triggeredBy(e);
            var type = toLowerCase(element.nodeName);
            if (type != 'textarea' && type != 'a') {
                if (keyMap) {
                    var elementID = keyMap[keyCode(e)];
                    if (elementID) {
                        element = lookupElementById(elementID);
                        submit(ev || window.event, element);
                        return false;
                    }
                }
                if (isEnterKey(e)) {
                    var cursor = element;
                    while (cursor && !cursor.submitOnEnter) {
                        cursor = cursor.parentNode;
                    }
                    if (cursor && cursor.submitOnEnter == 'disabled') {
                        return false;
                    } else {
                        submit(ev || window.event, element);
                        return false;
                    }
                }
                return true;
            }
        };
        if (f.addEventListener) {
            f.addEventListener('keydown', captureKeypress, true);
        } else {
            f.attachEvent('onkeydown', captureKeypress);
        }
    };
    namespace.captureSubmit = function(id) {
        var f = document.getElementById(id);
        if (f.enctype != 'multipart/form-data') {
            f.nativeSubmit = f.submit;
            f.submit = function() {
                var theEvent;
                if (window.event) {
                    theEvent = window.event;
                } else {
                    var maybeCaller = arguments.callee.caller;
                    var originalEvent;
                    while (!(maybeCaller && originalEvent && (originalEvent.target || originalEvent.srcElement))) {
                        maybeCaller = maybeCaller.caller;
                        originalEvent = maybeCaller.arguments[0];
                    }
                    theEvent = originalEvent;
                }
                submit(theEvent, f);
            }
        };
        each(['onkeydown', 'onkeypress', 'onkeyup', 'onclick', 'ondblclick', 'onchange'], function(name) {
            f[name] = function(e) {
                var event = e || window.event;
                var element = event.target || event.srcElement;
                f.onsubmit = function() {
                    if (element.name && !element.id) {
                        var lookedUpElement = document.getElementById(element.name);
                        if (!lookedUpElement || !lookedUpElement.id) {
                            element.id = element.name;
                        }
                    }
                    if (window.mojarra && arguments.callee.caller == window.mojarra.jsfcljs) {
                        submit(null, f);
                        return false;
                    } else {
                        var elementExists = document.getElementById(element.id);
                        submit(event, elementExists ? elementExists : f);
                        f.onsubmit = null;
                        return false;
                    }
                };
            };
        });
    };
})();
(function() {
    namespace.enableSingleSubmit = function(id, useBlur) {
        var f = document.getElementById(id);
        f.singleSubmit = 'enabled';
        function submitForm(ev, beforeSubmit, afterSubmit) {
            var eType;
            if (window.event) {
                eType = window.event.type;
            } else {
                eType = ev.type;
            }
            if (0 == eType.indexOf("on")) {
                eType = eType.substr(2);
            }
            var e = $event(ev, f);
            var element = triggeredBy(e);
            var cursor = element;
            while (cursor && !cursor.singleSubmit) {
                cursor = cursor.parentNode;
            }
            if (cursor && cursor.singleSubmit == 'disabled') {
                return;
            }
            var elementType = element.type;
            if (!elementType) {
                return false;
            }
            elementType = toLowerCase(elementType);
            if ((null == element.id) || ("" == element.id)) {
                return;
            }
            var isText = ( (elementType == "text") ||
                (elementType == "password") ||
                (elementType == "textarea") );
            if (isText) {
                if ((eType == "click") || !useBlur && eType == "blur") {
                    return;
                }
                if (!useBlur && eType == "focusout") {
                    if (element.value == element.previousTextValue) {
                        return;
                    }
                    element.previousTextValue = element.value;
                }
            }
            if (elementType == 'radio' || elementType == 'checkbox') {
                if (eType == "focusout") {
                    return;
                }
            }
            if (elementType == ("select-one")) {
                if (eType != 'change') {
                    if (eType == 'click' && element.selectedIndex <= 0 && !element.previouslySelected) {
                        element.previouslySelected = element.selectedIndex;
                        return;
                    }
                    if (element.selectedIndex == element.previouslySelected) {
                        return;
                    }
                    element.previouslySelected = element.selectedIndex;
                }
            }
            if (elementType == ("select-multiple")) {
                if (eType != 'change') {
                    var numberOfSelected = 0;
                    for (var i = 0; i < element.options.length; i++) {
                        if (element.options[i].selected) {
                            numberOfSelected++;
                        }
                    }
                    if (numberOfSelected == element.previousNumberOfSelected &&
                        element.selectedIndex == element.previouslySelected) {
                        return;
                    }
                    element.previouslySelected = element.selectedIndex;
                    element.previousNumberOfSelected = numberOfSelected;
                }
            }
            ice.setFocus(null);
            if (beforeSubmit) {
                beforeSubmit();
            }
            ice.se(e, element, null, function(onBeforeSubmit, onBeforeUpdate) {
                if (afterSubmit) {
                    onBeforeUpdate(afterSubmit);
                }
            });
            return true;
        }
        var isIE11orEdge = /Trident.*rv\:11\./.test(navigator.userAgent)
                           || /Edge\/\d+/.test(navigator.userAgent);
        if (!f.attachEvent && !isIE11orEdge) {
            function submitFormOnChange(e) {
                var onSubmit = f.onsubmit;
                submitForm(e, function () {
                        f.onsubmit = noop;
                        f.removeEventListener('click', submitFormOnClick);
                    }, function () {
                        f.onsubmit = onSubmit;
                        f.addEventListener('click', submitFormOnClick, false);
                    });
            }
            function submitFormOnClick(e) {
                var onSubmit = f.onsubmit;
                submitForm(e, function() {
                            f.onsubmit = noop;
                            f.removeEventListener('change', submitFormOnChange);
                            var ev = $event(e);
                            if (triggeredBy(ev).type == 'submit') {
                                cancel(ev);
                            } else {
                                cancelBubbling(ev);
                            }
                        }, function() {
                            f.onsubmit = onSubmit;
                            f.addEventListener('change', submitFormOnChange, false);
                        });
            }
            f.addEventListener('blur', submitForm, useBlur);
            f.addEventListener('change', submitFormOnChange, false);
            f.addEventListener('click', submitFormOnClick, false);
        } else {
            function submitFormOnClick(e) {
                var onSubmit = f.onsubmit;
                submitForm(e, function() {
                    f.onsubmit = noop;
                    var ev = $event(e);
                    if (triggeredBy(ev).type == 'submit') {
                        cancel(ev);
                    } else {
                        cancelBubbling(ev);
                    }
                }, function() {
                    f.onsubmit = onSubmit;
                });
            }
            if (f.addEventListener) {
                f.addEventListener('focusout', submitForm, false);
                f.addEventListener('click', submitFormOnClick, false);
            } else {
                f.attachEvent('onfocusout', submitForm);
                f.attachEvent('onclick', submitFormOnClick);
            }
        }
    };
    namespace.cancelSingleSubmit = function(id) {
        if (typeof id != "string") return;
        var f = document.getElementById(id);
        if (!f) return;
        var cancelBubble = function (event) {
            event = event || window.event;
            if (event.stopPropagation) event.stopPropagation();
            event.cancelBubble = true;
        };
        if (f.addEventListener) {
            f.addEventListener('blur', cancelBubble, false);
            f.addEventListener('change', cancelBubble, false);
        } else {
            f.attachEvent('onfocusout', cancelBubble);
            f.attachEvent('onclick', cancelBubble);
        }
    };
    namespace.disableSingleSubmit = function(id) {
        var element = lookupElementById(id);
        element.singleSubmit = 'disabled';
    };
})();
(function() {
    function isComponentRendered(form) {
        return lookupNamedInputElement(form, 'javax.faces.encodedURL') ||
            lookupNamedInputElement(form, 'javax.faces.ViewState') ||
            lookupNamedInputElement(form, 'ice.window') ||
            lookupNamedInputElement(form, 'ice.view') ||
            (form.id && form[form.id] && form.id == form[form.id].value);
    }
    function ifViewStateUpdated(updates, callback) {
        var viewStateUpdate = detect(updates.getElementsByTagName('update'), function(update) {
            return contains(update.getAttribute('id'), 'javax.faces.ViewState');
        });
        if (viewStateUpdate) {
            callback(viewStateUpdate.firstChild.data);
        }
    }
    function collectUpdatedForms(updates, iterator) {
        each(updates.getElementsByTagName('update'), function(update) {
            var id = update.getAttribute('id');
            var e = lookupElementById(id);
            if (e) {
                if (toLowerCase(e.nodeName) == 'form') {
                    if (isComponentRendered(e)) {
                        iterator(e);
                    }
                } else {
                    var markup = join(collect(update.childNodes, function(cdata) {
                        return cdata.data;
                    }), '');
                    var formStartTags = markup.match(/\<form[^\<]*\>/g);
                    if (formStartTags) {
                        each(formStartTags, function(formStartTag) {
                            var match = formStartTag.match(/id="([\S]*?)"/im);
                            if (match && match[1]) {
                                var id = match[1];
                                var form = document.getElementById(id);
                                if (form && isComponentRendered(form)) {
                                    iterator(form);
                                }
                            }
                        });
                    }
                }
            }
        });
    }
    namespace.onAfterUpdate(function(updates) {
        ifViewStateUpdated(updates, function(viewState) {
            collectUpdatedForms(updates, function(form) {
                try {
                    var viewStateElement = lookupViewStateElement(form);
                    if (viewStateElement.value != viewState) {
                        viewStateElement.value = viewState;
                    }
                } catch (ex) {
                    appendHiddenInputElement(form, 'javax.faces.ViewState', viewState, viewState);
                    debug(logger, 'append missing "javax.faces.ViewState" input element to form["' + form.id + '"]');
                }
            });
        });
    });
    var formViewID;
    namespace.onBeforeSubmit(function(source) {
        var inputElement = lookupNamedInputElement(formOf(source), 'ice.view');
        formViewID = inputElement ? inputElement.value : null;
    });
    namespace.onAfterUpdate(function(updates) {
        ifViewStateUpdated(updates, function(viewState) {
            each(document.getElementsByTagName('form'), function(form) {
                var viewIDElement = lookupNamedInputElement(form, 'ice.view');
                var viewStateElement = lookupNamedInputElement(form, 'javax.faces.ViewState');
                if (viewStateElement && viewIDElement && viewIDElement.value == formViewID) {
                    viewStateElement.value = viewState;
                }
            });
        });
    });
    function fixViewState(id, viewState) {
        var form = lookupElementById(id);
        try {
            var viewStateElement = lookupViewStateElement(form);
            if (viewStateElement.value != viewState) {
                viewStateElement.value = viewState;
            }
        } catch (ex) {
            appendHiddenInputElement(form, 'javax.faces.ViewState', viewState, viewState);
        }
    }
    namespace.fixViewStates = function(formIds, viewState) {
        for( var i = 0; i < formIds.length; i++){
            fixViewState(formIds[i],viewState);
        }
    };
})();
var switchToClientSideElementUpdateDetermination;
(function() {
    var elementUpdateListeners = [];
    namespace.onElementUpdate = function(id, callback) {
        var element = lookupElementById(id);
        if (element) {
            element['data-onElementUpdate'] = callback;
        } else {
            warn(logger, 'Cannot find element [' + id + '] to assign onElementUpdate callback.');
        }
    };
    function clientSideOnElementUpdate(id, callback) {
        var element = lookupElementById(id);
        var ancestorIDs = [];
        var cursor = element;
        while (cursor) {
            var cursorID;
            if (cursor == document.body) {
                cursorID = 'javax.faces.ViewBody';
            } else if (cursor == document.documentElement) {
                cursorID = 'javax.faces.ViewRoot';
            } else if (cursor == document.getElementsByTagName('head')[0]) {
                cursorID = 'javax.faces.ViewHead';
            } else {
                cursorID = cursor.id;
            }
            if (cursorID) {
                ancestorIDs.push(cursorID);
            }
            cursor = cursor.parentNode;
        }
        append(elementUpdateListeners, {identifier: id, handler: callback, ancestors: ('*' + ancestorIDs.join('*') + '*')});
        return removeCallbackCallback(elementUpdateListeners, function(c) {
            return id == c.id;
        });
    }
    switchToClientSideElementUpdateDetermination = function() {
        namespace.onElementUpdate = clientSideOnElementUpdate;
        namespace.onBeforeUpdate(function(updates) {
            each(updates.getElementsByTagName('update'), findAndNotifyUpdatedElements);
            each(updates.getElementsByTagName('delete'), findAndNotifyUpdatedElements);
        });
    };
    function findAndNotifyUpdatedElements(update) {
        var updatedElementId = update.getAttribute('id');
        if (contains(updatedElementId, 'javax.faces.ViewState')) {
            return;
        }
        var fvsTail = updatedElementId.substr(updatedElementId.length - 13);
        if ('_fixviewstate' === fvsTail) {
            return;
        }
        var updatedElement = lookupElementById(updatedElementId);
        if (updatedElement) {
            elementUpdateListeners = reject(elementUpdateListeners, function(idCallbackTuple) {
                var updated = contains(idCallbackTuple.ancestors, '*' + updatedElementId + '*');
                if (updated) {
                    var id = idCallbackTuple.identifier;
                    var element = lookupElementById(id);
                    if (element) {
                        var callback = idCallbackTuple.handler;
                        try {
                            callback(element);
                        } catch (e) {
                        }
                    }
                    return true;
                } else {
                    return false;
                }
            });
        }
    }
    namespace.notifyOnElementUpdateCallbacks = function(ids) {
        each(ids, function(id) {
            var e = lookupElementById(id);
            if (e) {
                var callback = e['data-onElementUpdate'];
                if (callback) {
                    try {
                        callback(id);
                    } catch (ex) {
                        warn(logger, 'onElementUpdate callback for [' + id + '] failed to run properly', ex);
                    } finally {
                        e['data-onElementUpdate'] = null;
                    }
                }
            }
        });
    };
    namespace.notifyAllOnElementUpdateCallbacks = function() {
        var elements = document.body.getElementsByTagName('*');
        for (var i = 0, l = elements.length; i < l; i++) {
            var e = elements[i];
            var callback;
			if (e) callback = e['data-onElementUpdate'];
            if (callback) {
                var id = e.id;
                try {
                    callback(id);
                } catch (ex) {
                    warn(logger, 'onElementUpdate callback for [' + id + '] failed to run properly', ex);
                } finally {
                    if (e) e['data-onElementUpdate'] = null;
                }
            }
        }
    };
})();
(function() {
    var elementRemoveListeners = [];
    namespace.onElementRemove = function(id, callback) {
        append(elementRemoveListeners, {i: id, c: callback});
        return removeCallbackCallback(elementRemoveListeners, detectByReference(callback));
    };
    namespace.onAfterUpdate(function() {
        each(elementRemoveListeners, function(tuple) {
            var notFound = true;
            try {
                notFound = !document.getElementById(tuple.i);
            } catch (ex) {
                notFound = true;
            }
            if (notFound) {
                try {
                    tuple.c();
                } catch (ex) {
                    warn(logger, 'failed to execute onElementRemove callback for element ' + tuple.i);
                }
            }
        });
    });
})();
(function() {
    var userInactivityListeners = [];
    var notifiedUserInactivityListeners = [];
    var isUserInactivityMonitorStarted = false;
    namespace.onUserInactivity = function(timeout, idleUserCallback, activeUserCallback, userActiveEvents) {
        if (!isUserInactivityMonitorStarted) {
            isUserInactivityMonitorStarted = true;
            observeUserInactivity(userActiveEvents || [ 'keydown', 'mouseover' ]);
        }
        var tuple = {interval: (timeout * 1000), idleCallback: idleUserCallback, activeCallback: activeUserCallback};
        append(userInactivityListeners, tuple);
        return removeCallbackCallback(userInactivityListeners, detectByReference(tuple));
    };
    function observeUserInactivity(userActiveEvents) {
        var userActivityMonitor = Delay(function() {
            var now = (new Date).getTime();
            var additionalNotifiedListeners = select(userInactivityListeners, function(tuple) {
                var interval = tuple.interval;
                var runCallback = now > lastActivityTime + interval;
                if (runCallback) {
                    var callback = tuple.idleCallback;
                    try {
                        callback();
                    } catch (ex) {
                        warn(logger, 'onUserInactivity idle user callback failed to run', ex);
                    }
                }
                return runCallback;
            });
            userInactivityListeners = complement(userInactivityListeners, additionalNotifiedListeners);
            notifiedUserInactivityListeners = concatenate(notifiedUserInactivityListeners, additionalNotifiedListeners);
        }, 3 * 1000);
        run(userActivityMonitor);
        var stopActivityMonitor = curry(stop, userActivityMonitor);
        namespace.onSessionExpiry(stopActivityMonitor);
        namespace.onNetworkError(stopActivityMonitor);
        namespace.onServerError(stopActivityMonitor);
        namespace.onUnload(stopActivityMonitor);
        var lastActivityTime = (new Date).getTime();
        function resetUserInactivity() {
            lastActivityTime = (new Date).getTime();
            if (notEmpty(notifiedUserInactivityListeners)) {
                each(notifiedUserInactivityListeners, function(tuple) {
                    var callback = tuple.activeCallback;
                    if (callback) {
                        try {
                            callback();
                        } catch (ex) {
                            warn(logger, 'onUserInactivity active user callback failed to run', ex);
                        }
                    }
                });
                userInactivityListeners = concatenate(userInactivityListeners, notifiedUserInactivityListeners);
                notifiedUserInactivityListeners = [];
            }
        }
        each(userActiveEvents, function(e) {
            registerListener(e, document, resetUserInactivity);
        });
    }
})();
var setupDefaultIndicators;
(function () {
    var off = operator();
    function PopupIndicator(message, description, panel) {
        var backPanel = panel();
        var messageContainer = document.body.appendChild(document.createElement('div'));
        messageContainer.className = 'ice-status-indicator';
        var messageContainerStyle = messageContainer.style;
        messageContainerStyle.position = 'absolute';
        messageContainerStyle.textAlign = 'center';
        messageContainerStyle.zIndex = '28001';
        messageContainerStyle.color = 'black';
        messageContainerStyle.backgroundColor = 'white';
        messageContainerStyle.paddingLeft = '10px';
        messageContainerStyle.paddingRight = '10px';
        messageContainerStyle.paddingTop = '15px';
        messageContainerStyle.paddingBottom = '15px';
        messageContainerStyle.borderBottomColor = 'gray';
        messageContainerStyle.borderRightColor = 'gray';
        messageContainerStyle.borderTopColor = 'silver';
        messageContainerStyle.borderLeftColor = 'silver';
        messageContainerStyle.borderWidth = '2px';
        messageContainerStyle.borderStyle = 'solid';
        var messageElement = messageContainer.appendChild(document.createElement('div'));
        messageElement.appendChild(document.createTextNode(message));
        messageElement.className = 'ice-status-indicator-message';
        var messageElementStyle = messageElement.style;
        messageElementStyle.textAlign = 'left';
        messageElementStyle.fontSize = '14px';
        messageElementStyle.fontSize = '14px';
        messageElementStyle.fontWeight = 'bold';
        var descriptionElement = messageElement.appendChild(document.createElement('div'));
        descriptionElement.innerHTML = description;
        descriptionElement.className = 'ice-status-indicator-description';
        var descriptionElementStyle = descriptionElement.style;
        descriptionElementStyle.fontSize = '11px';
        descriptionElementStyle.marginTop = '7px';
        descriptionElementStyle.marginBottom = '7px';
        descriptionElementStyle.fontWeight = 'normal';
        var resize = function () {
            messageContainerStyle.left = ((window.width() - messageContainer.clientWidth) / 2) + 'px';
            messageContainerStyle.top = ((window.height() - messageContainer.clientHeight) / 2) + 'px';
        };
        resize();
        var clearOnResize = onResize(window, resize);
        return object(function (method) {
            method(off, function (self) {
                if (messageContainer) {
                    try {
                        document.body.removeChild(messageContainer);
                        clearOnResize();
                        off(backPanel);
                    } finally {
                        messageContainer = null;
                    }
                }
            });
        });
    }
    function BackgroundOverlay(container) {
        return function () {
            var overlay = container.ownerDocument.createElement('iframe');
            overlay.setAttribute('src', 'about:blank');
            overlay.setAttribute('frameborder', '0');
            overlay.className = 'ice-status-indicator-overlay';
            var overlayStyle = overlay.style;
            overlayStyle.top = '0';
            overlayStyle.left = '0';
            container.appendChild(overlay);
            var resize = container.tagName.toLowerCase() == 'body' ?
                function () {
                    overlayStyle.width = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth) + 'px';
                    overlayStyle.height = Math.max(document.documentElement.scrollHeight, document.body.scrollHeight) + 'px';
                } :
                function () {
                    overlayStyle.width = container.offsetWidth + 'px';
                    overlayStyle.height = container.offsetHeight + 'px';
                };
            resize();
            var clearOnResize = onResize(window, resize)
            return object(function (method) {
                method(off, function (self) {
                    if (overlay) {
                        try {
                            container.removeChild(overlay);
                            clearOnResize();
                        } finally {
                            overlay = null;
                        }
                    }
                });
            });
        }
    }
    function extractTagContent(tag, html) {
        var start = new RegExp('\<' + tag + '[^\<]*\>', 'g').exec(html);
        var end = new RegExp('\<\/' + tag + '\>', 'g').exec(html);
        var tagWithContent = html.substring(start.index, end.index + end[0].length);
        return tagWithContent.substring(tagWithContent.indexOf('>') + 1, tagWithContent.lastIndexOf('<'));
    }
    setupDefaultIndicators = function (container, configuration) {
        var overlay = BackgroundOverlay(container);
        var beforeSessionExpiryIndicator = object(function (method) {
            method(off, noop);
        });
        function showIndicators() {
            return !(namespace.disableDefaultErrorPopups || configuration.disableDefaultErrorPopups);
        }
        namespace.onServerError(function (code, html, xmlContent) {
            if (showIndicators()) {
                var message;
                var description;
                if (xmlContent) {
                    message = xmlContent.getElementsByTagName("error-message")[0].firstChild.nodeValue;
                    description = xmlContent.getElementsByTagName("error-name")[0].firstChild.nodeValue;
                } else {
                    message = extractTagContent('title', html);
                    description = extractTagContent('body', html);
                }
                PopupIndicator(message, description, overlay);
            }
        });
        namespace.onNetworkError(function () {
            if (showIndicators()) {
                PopupIndicator("Network Connection Interrupted", "Reload this page to try to reconnect.", overlay);
            }
        });
        namespace.onSessionExpiry(function () {
            if (showIndicators()) {
                off(beforeSessionExpiryIndicator);
                PopupIndicator("User Session Expired", "Reload this page to start a new user session.", overlay);
            }
        });
        namespace.onBeforeSessionExpiry(function (time) {
            if (showIndicators()) {
                beforeSessionExpiryIndicator = PopupIndicator("User Session is about to expire in " + time + " seconds.", "Reload this page to keep your current user session.", overlay);
            }
        });
    }
})();
(function() {
    function extractTagContent(tag, html) {
        var start = new RegExp('\<' + tag + '[^\<]*\>', 'g').exec(html);
        var end = new RegExp('\<\/' + tag + '\>', 'g').exec(html);
        if (start && end && start.index && end.index) {
            var tagWithContent = html.substring(start.index, end.index + end[0].length);
            return tagWithContent.substring(tagWithContent.indexOf('>') + 1, tagWithContent.lastIndexOf('<'));
        } else {
            return '';
        }
    }
    function extractAttributeValue(html, name, defaultValue) {
        var re = new RegExp(name + '="([\\S]*?)"', 'im');
        var result = html.match(re);
        return result ? result[1] : defaultValue;
    }
    function extractSrcAttribute(html) {
        return extractAttributeValue(html, 'src');
    }
    function unescapeHtml(text) {
        if (text) {
            var temp = document.createElement("div");
            temp.innerHTML = text;
            var result = temp.firstChild.data;
            temp.removeChild(temp.firstChild);
            return result;
        } else {
            return text;
        }
    }
    function stripPathParameters(url) {
        try {
            var semicolonPosition = indexOf(url, ';');
            var newURL = substring(url, 0, semicolonPosition);
            try {
                var questionPosition = indexOf(url, '?');
                return newURL + substring(url, questionPosition, url.length);
            } catch (e) {
                return newURL;
            }
        } catch (e) {
            return url;
        }
    }
    var client = Client();
    var scriptElementMatcher = /<script[^>]*>([\S\s]*?)<\/script>/igm;
    function extractAndEvaluateScripts(content) {
        var scriptTags = content.match(scriptElementMatcher);
        if (scriptTags) {
            var scripts = collect(scriptTags, function(script) {
                var src = extractSrcAttribute(script);
                var code;
                if (src) {
                    src = stripPathParameters(unescapeHtml(src));
                    if (contains(scriptRefs, src)) {
                        code = '';
                    } else {
                        getSynchronously(client, src, noop, noop, function(response) {
                            code = contentAsText(response);
                        });
                        append(scriptRefs, src);
                    }
                } else {
                    code = unescapeHtml(extractTagContent('script', script));
                }
                return code;
            });
            each(select(scripts, identity), namespace.globalEval);
        }
    }
    var linkElementMatcher = /<link[^>]*>/igm;
    function extractAndAppendStyles(content) {
        var linkTags = content.match(linkElementMatcher);
        if (linkTags) {
            var newLinkRefs = collect(select(linkTags,
                function(linkTag) {
                    return extractAttributeValue(linkTag, 'type') == 'text/css';
            }), function(linkTag) {
                    return replace(extractAttributeValue(linkTag, 'href'), '&amp;', '&');
            });
            var headElement = document.getElementsByTagName("head")[0];
            var addedLinkRefs = complement(newLinkRefs, linkRefs);
            each(addedLinkRefs, function(src) {
                var code;
                getSynchronously(client, src, noop, noop, function(response) {
                    code = contentAsText(response);
                });
                var styleElement = document.createElement('style');
                styleElement.type = 'text/css';
                headElement.appendChild(styleElement);
                if (styleElement.styleSheet) {   
                    styleElement.styleSheet.cssText = code;
                } else {                
                    var textNode = document.createTextNode(code);
                    styleElement.appendChild(textNode);
                }
            });
            linkRefs = newLinkRefs;
        }
    }
    var scriptRefs = [];
    var linkRefs = [];
    function createResourceMatching(attribute) {
        return function(result, s) {
            var src = s.getAttribute(attribute);
            if (src) {
                append(result, stripPathParameters(src));
            }
            return result;
        };
    }
    onLoad(window, function() {
        var scriptElements = document.documentElement.getElementsByTagName('script');
        inject(scriptElements, scriptRefs, createResourceMatching('src'));
    });
    onLoad(window, function() {
        var linkElements = document.documentElement.getElementsByTagName('link');
        inject(linkElements, linkRefs, createResourceMatching('href'));
    });
    function findViewRootUpdate(content) {
        return detect(content.getElementsByTagName('update'), function(update) {
            return update.getAttribute('id') == 'javax.faces.ViewRoot';
        });
    }
    onLoad(window, function() {
        document.documentElement.isHeadUpdateSuccessful = null;
    });
    namespace.onBeforeUpdate(function(content) {
        var headUpdate = detect(content.getElementsByTagName('extension'), function(update) {
            return update.getAttribute('type') == 'javax.faces.ViewHead';
        });
        var originalDocumentWrite = document.write;
        document.write = noop;
        if (headUpdate) {
            var innerContent = headUpdate.firstChild.data;
            extractAndEvaluateScripts(innerContent);
            extractAndAppendStyles(innerContent);
            document.title = extractTagContent('title', innerContent);
        }
        document.write = originalDocumentWrite;
    });
    namespace.onAfterUpdate(function(content) {
        var rootUpdate = findViewRootUpdate(content);
        if (rootUpdate && !document.documentElement.isHeadUpdateSuccessful) {
            var headContent = extractTagContent('head', rootUpdate.firstChild.data);
            extractAndEvaluateScripts(headContent);
            extractAndAppendStyles(headContent);
        } else {
            document.documentElement.isHeadUpdateSuccessful = null;
        }
        if (rootUpdate) {
            document.title = extractTagContent('title', rootUpdate.firstChild.data);
        }
    });
    namespace.onBeforeUpdate(function(updates) {
        each(updates.getElementsByTagName('update'), function(update) {
            var id = update.getAttribute('id');
            var updatedElement = lookupElementById(id);
            if (updatedElement) {
                each(updatedElement.getElementsByTagName('iframe'), function(iframe) {
                    if (iframe && iframe.parentNode) {
                        iframe.parentNode.removeChild(iframe);
                    }
                });
            }
        });
    });
    if (!/MSIE/.test(navigator.userAgent)) {
        namespace.onBeforeUpdate(function(content) {
            var rootUpdate = findViewRootUpdate(content);
            if (rootUpdate) {
                var configuration = document.body.configuration;
                if (configuration) {
                    document.documentElement.configuration = configuration;
                }
            }
        });
    }
    try {
        document.execCommand("BackgroundImageCache", false, true);
    } catch(err) {
    }
})();
    })(window.ice);
}
