package org.icesoft.demo.spring.secure;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

/**
 * This class was born from the same methods in the classes provided by the
 * Icefaces 2.0b2 sample applications.
 *
 * @author Ben Simpson
 */
public class FacesUtils {


    /**
     * Given a bean name, get the backing bean associated with it.  Even though spring is in use
     * in this sample application - we use the JSF context.  That is because we don't need to make
     * anything more complicated than it already is.
     *
     * @param beanName String name of the bean: like breadcrumbBean
     * @return Object to be cast to bean type
     */
    public static Object getBackingBean(String beanName) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ValueExpression valueExpression =
                expressionFactory.createValueExpression(elContext, convertToElSyntax(beanName), Object.class);
        return valueExpression.getValue(elContext);
    }


    private static String convertToElSyntax(String value) {
        return new StringBuffer("#{").append(value).append("}").toString();
    }
}
