package org.icesoft.demo.spring.secure.session;

/**
 * This class represents...
 *
 * @author Ben Simpson <ben.simpson@icesoft.com>
 *         Date: 2/9/11
 *         Time: 1:20 PM
 */

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import java.util.Date;

/**
 *
 * @author jc598g
 */
public class MyHttpSessionListener implements HttpSessionListener {

	public void sessionCreated(HttpSessionEvent se) {
		HttpSession session = se.getSession();
		System.out.print("MyHttpSessionListener.sessionCreated: " + getTime() + " (session) Created:");
		System.out.println("ID=" + session.getId() + " MaxInactiveInterval="
		 + session.getMaxInactiveInterval());
	}

	public void sessionDestroyed(HttpSessionEvent se) {
		HttpSession session = se.getSession();
		// session has been invalidated and all session data
		//(except Id)is no longer available
                System.out.println("MyHttpSessionListener.sessionDestroyed: " + getTime() + " (session) Destroyed:ID=" + session.getId());
	}

	private String getTime() {
		return new Date(System.currentTimeMillis()).toString();
	}
}
